from enum import Enum

from be_kit.enums import StrEnumWithMixins
from be_uam.kit.enums import MetadataOrderingMixin


class WarehouseRemovalStrategy(Enum):
    FIFO = "FIFO"
    LIFO = "LIFO"
    FEFO = "FEFO"


class WarehouseOrdering(MetadataOrderingMixin, StrEnumWithMixins):
    NAME = "name"
    NAME_DESC = "-name"
    DESCRIPTION = "description"
    DESCRIPTION_DESC = "-description"
    IDENTIFIER = "identifier"
    IDENTIFIER_DESC = "-identifier"
    REMOVAL_STRATEGY = "removal_strategy"
    REMOVAL_STRATEGY_DESC = "-removal_strategy"
