from be_uam.permission.utils import generate_permission_list


permissions = generate_permission_list(
    app="inventory",
    module="product",
    submodule="product_category",
    action=[
        "create",
        "read",
        "update",
        "delete",
    ],
)


product_category_permission_mapper = {
    "create_product_category": ["inventory.product.product_category.create"],
    "retrieve_product_category": ["inventory.product.product_category.read"],
    "update_product_category": ["inventory.product.product_category.update"],
    "list_product_category": ["inventory.product.product_category.read"],
    "list_product_category_option": ["inventory.product.product_category.read"],
    "delete_product_category": ["inventory.product.product_category.delete"],
}


permissions += generate_permission_list(
    app="inventory",
    module="product",
    submodule="product",
    action=[
        "create",
        "read",
        "update",
        "delete",
    ],
)


product_permission_mapper = {
    "create_product": ["inventory.product.product.create"],
    "retrieve_product": ["inventory.product.product.read"],
    "update_product": ["inventory.product.product.update"],
    "list_product": ["inventory.product.product.read"],
    "list_product_option": ["inventory.product.product.read"],
    "delete_product": ["inventory.product.product.delete"],
    "download_upload_product_template": ["inventory.product.product.create"],
    "upload_product": ["inventory.product.product.create"],
    "download_product": ["inventory.product.product.read"],
}


permissions += generate_permission_list(
    app="inventory",
    module="product",
    submodule="product_stock",
    action=[
        "create",
        "read",
        "update",
        "delete",
    ],
)


product_stock_permission_mapper = {
    "create_product_stock": ["inventory.product.product_stock.create"],
    "retrieve_product_stock": ["inventory.product.product_stock.read"],
    "update_product_stock": ["inventory.product.product_stock.update"],
    "list_product_stock": ["inventory.product.product_stock.read"],
    "list_product_stock_option": ["inventory.product.product_stock.read"],
    "delete_product_stock": ["inventory.product.product_stock.delete"],
}


permissions += generate_permission_list(
    app="inventory",
    module="product",
    submodule="product_movement",
    action=[
        "create",
        "read",
        "update",
        "delete",
    ],
)


product_movement_permission_mapper = {
    "create_product_movement": ["inventory.product.product_movement.create"],
    "retrieve_product_movement": ["inventory.product.product_movement.read"],
    "update_product_movement": ["inventory.product.product_movement.update"],
    "update_product_movement_status": ["inventory.product.product_movement.update"],
    "approve_product_movement": ["inventory.product.product_movement.update"],
    "list_product_movement": ["inventory.product.product_movement.read"],
    "list_product_movement_option": ["inventory.product.product_movement.read"],
    "delete_product_movement": ["inventory.product.product_movement.delete"],
}
