from enum import Enum

from be_kit.enums import StrEnumWithMixins
from be_uam.kit.enums import MetadataOrderingMixin

class ProductRemovalStrategy(Enum):
    FIFO = "FIFO"
    LIFO = "LIFO"
    FEFO = "FEFO"

class ProductType(Enum):
    GOODS = "Goods"
    SERVICES = "Services"


class ProductUnit(Enum):
    PIECE = "Piece"
    KG = "Kg"
    LITRE = "Litre"
    METER = "Meter"
    SQUARE_METER = "Square Meter"
    CUBIC_METER = "Cubic Meter"
    BOX = "Box"
    BAG = "Bag"
    BOTTLE = "Bottle"
    CAN = "Can"
    TUBE = "Tube"
    ROLL = "Roll"
    SET = "Set"
    PAIR = "Pair"
    DOZEN = "Dozen"
    PACK = "Pack"
    REAM = "Ream"
    BUNDLE = "Bundle"
    KIT = "Kit"
    UNIT = "Unit"
    OTHER = "Other"
    UNKNOWN = "Unknown"
    CUSTOM = "Custom"


class ProductMovementType(Enum):
    IN = "In"
    OUT = "Out"
    RESERVED = "Reserved"
    INTERNAL = "Internal"
    ADJUSTMENT = "Adjustment"
    SCRAP = "Scrap"


class ProductMovementStatus(Enum):
    DRAFT = "Draft"
    APPROVED = "Approved"
    COMPLETED = "Completed"
    CANCELLED = "Cancelled"


class ProductCategoryOrdering(MetadataOrderingMixin, StrEnumWithMixins):
    NAME = "name"
    NAME_DESC = "-name"
    DESCRIPTION = "description"
    DESCRIPTION_DESC = "-description"


class ProductOrdering(MetadataOrderingMixin, StrEnumWithMixins):
    NAME = "name"
    NAME_DESC = "-name"
    DESCRIPTION = "description"
    DESCRIPTION_DESC = "-description"
    IDENTIFIER = "identifier"
    IDENTIFIER_DESC = "-identifier"
    PRODUCT_TYPE = "product_type"
    PRODUCT_TYPE_DESC = "-product_type"


class ProductStockOrdering(MetadataOrderingMixin, StrEnumWithMixins):
    IDENTIFIER = "identifier"
    IDENTIFIER_DESC = "-identifier"
    AVAILABLE = "available"
    AVAILABLE_DESC = "-available"
    RESERVED = "reserved"
    RESERVED_DESC = "-reserved"
    LOCKED = "locked"
    LOCKED_DESC = "-locked"


class ProductMovementOrdering(MetadataOrderingMixin, StrEnumWithMixins):
    IDENTIFIER = "identifier"
    IDENTIFIER_DESC = "-identifier"
    MOVEMENT_TYPE = "movement_type"
    MOVEMENT_TYPE_DESC = "-movement_type"
    STATUS = "status"
    STATUS_DESC = "-status"
