"""inventory: connected journal entry to product movement

Revision ID: 45dec250ec1f
Revises: f2b0221eadf6
Create Date: 2026-01-06 10:25:51.381482

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
import be_kit.databases


# revision identifiers, used by Alembic.
revision: str = '45dec250ec1f'
down_revision: Union[str, None] = 'f2b0221eadf6'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('inventory_product_movement', sa.Column('journal_entry_id', sa.BigInteger(), nullable=True))
    op.create_foreign_key(op.f('fk_inventory_product_movement_journal_entry_id_accounting_journal_entry'), 'inventory_product_movement', 'accounting_journal_entry', ['journal_entry_id'], ['pk'], ondelete='SET NULL')
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(op.f('fk_inventory_product_movement_journal_entry_id_accounting_journal_entry'), 'inventory_product_movement', type_='foreignkey')
    op.drop_column('inventory_product_movement', 'journal_entry_id')
    # ### end Alembic commands ###
