"""inventory: added journal relations

Revision ID: e3f5fd9a1678
Revises: 5f279103bb0a
Create Date: 2025-11-25 09:56:05.351332

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
import be_kit.databases


# revision identifiers, used by Alembic.
revision: str = 'e3f5fd9a1678'
down_revision: Union[str, None] = '5f279103bb0a'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('inventory_product', sa.Column('account_id', sa.BigInteger(), nullable=True))
    op.create_foreign_key(op.f('fk_inventory_product_account_id_accounting_coa_account'), 'inventory_product', 'accounting_coa_account', ['account_id'], ['pk'], ondelete='RESTRICT')
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(op.f('fk_inventory_product_account_id_accounting_coa_account'), 'inventory_product', type_='foreignkey')
    op.drop_column('inventory_product', 'account_id')
    # ### end Alembic commands ###
