"""inventory: added product removal strategy

Revision ID: 5f279103bb0a
Revises: 128cf2b5a835
Create Date: 2025-11-01 10:06:01.976526

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
import be_kit.databases
from sqlalchemy.dialects import mysql

# revision identifiers, used by Alembic.
revision: str = '5f279103bb0a'
down_revision: Union[str, None] = '128cf2b5a835'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('inventory_product', sa.Column('product_removal_strategy', sa.Enum('FIFO', 'LIFO', 'FEFO', name='productremovalstrategy'), nullable=False))
    op.alter_column('inventory_product_movement', 'movement_type',
               existing_type=mysql.ENUM('IN', 'OUT', 'SCRAP', 'ADJUSTMENT', 'INTERNAL', 'RESERVED'),
               type_=sa.Enum('IN', 'OUT', 'RESERVED', 'INTERNAL', 'ADJUSTMENT', 'SCRAP', name='productmovementtype'),
               nullable=False)
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.alter_column('inventory_product_movement', 'movement_type',
               existing_type=sa.Enum('IN', 'OUT', 'RESERVED', 'INTERNAL', 'ADJUSTMENT', 'SCRAP', name='productmovementtype'),
               type_=mysql.ENUM('IN', 'OUT', 'SCRAP', 'ADJUSTMENT', 'INTERNAL', 'RESERVED'),
               nullable=True)
    op.drop_column('inventory_product', 'product_removal_strategy')
    # ### end Alembic commands ###
