"""inventory: refactored initial migrations

Revision ID: 128cf2b5a835
Revises: 
Create Date: 2025-10-16 11:19:13.714962

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
import be_kit.databases


# revision identifiers, used by Alembic.
revision: str = '128cf2b5a835'
down_revision: Union[str, None] = None
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('inventory_product_counter',
    sa.Column('counter_date', sa.Date(), nullable=False),
    sa.Column('counter', sa.BigInteger(), nullable=False),
    sa.Column('organization_id', sa.BigInteger(), nullable=False),
    sa.Column('pk', sa.BigInteger(), nullable=False),
    sa.ForeignKeyConstraint(['organization_id'], ['uam_organization.pk'], name=op.f('fk_inventory_product_counter_organization_id_uam_organization'), ondelete='RESTRICT'),
    sa.PrimaryKeyConstraint('pk', name=op.f('pk_inventory_product_counter')),
    sa.UniqueConstraint('organization_id', 'counter_date', name=op.f('uq_inventory_product_counter_organization_id'))
    )
    op.create_index(op.f('ix_inventory_product_counter_counter_date'), 'inventory_product_counter', ['counter_date'], unique=False)
    op.create_table('inventory_product_movement_counter',
    sa.Column('counter_date', sa.Date(), nullable=False),
    sa.Column('counter', sa.BigInteger(), nullable=False),
    sa.Column('organization_id', sa.BigInteger(), nullable=False),
    sa.Column('pk', sa.BigInteger(), nullable=False),
    sa.ForeignKeyConstraint(['organization_id'], ['uam_organization.pk'], name=op.f('fk_inventory_product_movement_counter_organization_id_uam_organization'), ondelete='RESTRICT'),
    sa.PrimaryKeyConstraint('pk', name=op.f('pk_inventory_product_movement_counter')),
    sa.UniqueConstraint('organization_id', 'counter_date', name=op.f('uq_inventory_product_movement_counter_organization_id'))
    )
    op.create_index(op.f('ix_inventory_product_movement_counter_counter_date'), 'inventory_product_movement_counter', ['counter_date'], unique=False)
    op.create_table('inventory_warehouse',
    sa.Column('name', sa.String(length=100), nullable=False),
    sa.Column('description', sa.String(length=500), nullable=True),
    sa.Column('identifier', sa.String(length=10), nullable=False),
    sa.Column('removal_strategy', sa.Enum('FIFO', 'LIFO', 'FEFO', name='warehouseremovalstrategy'), nullable=False),
    sa.Column('deleted_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('organization_id', sa.BigInteger(), nullable=False),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('last_modified_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('created_by_id', sa.BigInteger(), nullable=True),
    sa.Column('last_modified_by_id', sa.BigInteger(), nullable=True),
    sa.Column('pk', sa.BigInteger(), nullable=False),
    sa.ForeignKeyConstraint(['created_by_id'], ['uam_user.pk'], name=op.f('fk_inventory_warehouse_created_by_id_uam_user'), ondelete='SET NULL'),
    sa.ForeignKeyConstraint(['last_modified_by_id'], ['uam_user.pk'], name=op.f('fk_inventory_warehouse_last_modified_by_id_uam_user'), ondelete='SET NULL'),
    sa.ForeignKeyConstraint(['organization_id'], ['uam_organization.pk'], name=op.f('fk_inventory_warehouse_organization_id_uam_organization'), ondelete='RESTRICT'),
    sa.PrimaryKeyConstraint('pk', name=op.f('pk_inventory_warehouse')),
    sa.UniqueConstraint('organization_id', 'name', name=op.f('uq_inventory_warehouse_organization_id'))
    )
    op.create_index(op.f('ix_inventory_warehouse_identifier'), 'inventory_warehouse', ['identifier'], unique=True)
    op.create_index(op.f('ix_inventory_warehouse_name'), 'inventory_warehouse', ['name'], unique=False)
    op.create_table('inventory_warehouse_counter',
    sa.Column('counter_date', sa.Date(), nullable=False),
    sa.Column('counter', sa.BigInteger(), nullable=False),
    sa.Column('organization_id', sa.BigInteger(), nullable=False),
    sa.Column('pk', sa.BigInteger(), nullable=False),
    sa.ForeignKeyConstraint(['organization_id'], ['uam_organization.pk'], name=op.f('fk_inventory_warehouse_counter_organization_id_uam_organization'), ondelete='RESTRICT'),
    sa.PrimaryKeyConstraint('pk', name=op.f('pk_inventory_warehouse_counter')),
    sa.UniqueConstraint('organization_id', 'counter_date', name=op.f('uq_inventory_warehouse_counter_organization_id'))
    )
    op.create_index(op.f('ix_inventory_warehouse_counter_counter_date'), 'inventory_warehouse_counter', ['counter_date'], unique=False)
    op.create_table('inventory_product_category',
    sa.Column('currency_id', sa.BigInteger(), nullable=False),
    sa.Column('name', sa.String(length=100), nullable=False),
    sa.Column('description', sa.String(length=500), nullable=True),
    sa.Column('deleted_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('organization_id', sa.BigInteger(), nullable=False),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('last_modified_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('created_by_id', sa.BigInteger(), nullable=True),
    sa.Column('last_modified_by_id', sa.BigInteger(), nullable=True),
    sa.Column('pk', sa.BigInteger(), nullable=False),
    sa.ForeignKeyConstraint(['created_by_id'], ['uam_user.pk'], name=op.f('fk_inventory_product_category_created_by_id_uam_user'), ondelete='SET NULL'),
    sa.ForeignKeyConstraint(['currency_id'], ['core_services_currency.pk'], name=op.f('fk_inventory_product_category_currency_id_core_services_currency'), ondelete='RESTRICT'),
    sa.ForeignKeyConstraint(['last_modified_by_id'], ['uam_user.pk'], name=op.f('fk_inventory_product_category_last_modified_by_id_uam_user'), ondelete='SET NULL'),
    sa.ForeignKeyConstraint(['organization_id'], ['uam_organization.pk'], name=op.f('fk_inventory_product_category_organization_id_uam_organization'), ondelete='RESTRICT'),
    sa.PrimaryKeyConstraint('pk', name=op.f('pk_inventory_product_category')),
    sa.UniqueConstraint('organization_id', 'name', name=op.f('uq_inventory_product_category_organization_id'))
    )
    op.create_index(op.f('ix_inventory_product_category_name'), 'inventory_product_category', ['name'], unique=False)
    op.create_table('inventory_product_movement',
    sa.Column('source_warehouse_id', sa.BigInteger(), nullable=True),
    sa.Column('destination_warehouse_id', sa.BigInteger(), nullable=True),
    sa.Column('identifier', sa.String(length=11), nullable=False),
    sa.Column('movement_type', sa.Enum('IN', 'OUT', 'INTERNAL', 'ADJUSTMENT', 'SCRAP', name='productmovementtype'), nullable=False),
    sa.Column('status', sa.Enum('DRAFT', 'APPROVED', 'COMPLETED', 'CANCELLED', name='productmovementstatus'), nullable=False),
    sa.Column('approver_id', sa.BigInteger(), nullable=True),
    sa.Column('note', sa.String(length=500), nullable=True),
    sa.Column('deleted_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('organization_id', sa.BigInteger(), nullable=False),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('last_modified_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('created_by_id', sa.BigInteger(), nullable=True),
    sa.Column('last_modified_by_id', sa.BigInteger(), nullable=True),
    sa.Column('pk', sa.BigInteger(), nullable=False),
    sa.ForeignKeyConstraint(['approver_id'], ['uam_user.pk'], name=op.f('fk_inventory_product_movement_approver_id_uam_user'), ondelete='SET NULL'),
    sa.ForeignKeyConstraint(['created_by_id'], ['uam_user.pk'], name=op.f('fk_inventory_product_movement_created_by_id_uam_user'), ondelete='SET NULL'),
    sa.ForeignKeyConstraint(['destination_warehouse_id'], ['inventory_warehouse.pk'], name=op.f('fk_inventory_product_movement_destination_warehouse_id_inventory_warehouse'), ondelete='RESTRICT'),
    sa.ForeignKeyConstraint(['last_modified_by_id'], ['uam_user.pk'], name=op.f('fk_inventory_product_movement_last_modified_by_id_uam_user'), ondelete='SET NULL'),
    sa.ForeignKeyConstraint(['organization_id'], ['uam_organization.pk'], name=op.f('fk_inventory_product_movement_organization_id_uam_organization'), ondelete='RESTRICT'),
    sa.ForeignKeyConstraint(['source_warehouse_id'], ['inventory_warehouse.pk'], name=op.f('fk_inventory_product_movement_source_warehouse_id_inventory_warehouse'), ondelete='RESTRICT'),
    sa.PrimaryKeyConstraint('pk', name=op.f('pk_inventory_product_movement'))
    )
    op.create_index(op.f('ix_inventory_product_movement_identifier'), 'inventory_product_movement', ['identifier'], unique=True)
    op.create_table('inventory_product',
    sa.Column('category_id', sa.BigInteger(), nullable=False),
    sa.Column('name', sa.String(length=100), nullable=False),
    sa.Column('description', sa.String(length=500), nullable=True),
    sa.Column('identifier', sa.String(length=10), nullable=False),
    sa.Column('product_type', sa.Enum('GOODS', 'SERVICES', name='producttype'), nullable=False),
    sa.Column('product_unit', sa.Enum('PIECE', 'KG', 'LITRE', 'METER', 'SQUARE_METER', 'CUBIC_METER', 'BOX', 'BAG', 'BOTTLE', 'CAN', 'TUBE', 'ROLL', 'SET', 'PAIR', 'DOZEN', 'PACK', 'REAM', 'BUNDLE', 'KIT', 'UNIT', 'OTHER', 'UNKNOWN', 'CUSTOM', name='productunit'), nullable=False),
    sa.Column('currency_id', sa.BigInteger(), nullable=False),
    sa.Column('price', be_kit.databases.NominalField(precision=30, scale=15), nullable=False),
    sa.Column('deleted_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('organization_id', sa.BigInteger(), nullable=False),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('last_modified_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('created_by_id', sa.BigInteger(), nullable=True),
    sa.Column('last_modified_by_id', sa.BigInteger(), nullable=True),
    sa.Column('pk', sa.BigInteger(), nullable=False),
    sa.ForeignKeyConstraint(['category_id'], ['inventory_product_category.pk'], name=op.f('fk_inventory_product_category_id_inventory_product_category'), ondelete='RESTRICT'),
    sa.ForeignKeyConstraint(['created_by_id'], ['uam_user.pk'], name=op.f('fk_inventory_product_created_by_id_uam_user'), ondelete='SET NULL'),
    sa.ForeignKeyConstraint(['currency_id'], ['core_services_currency.pk'], name=op.f('fk_inventory_product_currency_id_core_services_currency'), ondelete='RESTRICT'),
    sa.ForeignKeyConstraint(['last_modified_by_id'], ['uam_user.pk'], name=op.f('fk_inventory_product_last_modified_by_id_uam_user'), ondelete='SET NULL'),
    sa.ForeignKeyConstraint(['organization_id'], ['uam_organization.pk'], name=op.f('fk_inventory_product_organization_id_uam_organization'), ondelete='RESTRICT'),
    sa.PrimaryKeyConstraint('pk', name=op.f('pk_inventory_product')),
    sa.UniqueConstraint('organization_id', 'name', name=op.f('uq_inventory_product_organization_id'))
    )
    op.create_index(op.f('ix_inventory_product_identifier'), 'inventory_product', ['identifier'], unique=True)
    op.create_index(op.f('ix_inventory_product_name'), 'inventory_product', ['name'], unique=False)
    op.create_table('inventory_product_movement_item',
    sa.Column('movement_id', sa.BigInteger(), nullable=False),
    sa.Column('product_id', sa.BigInteger(), nullable=False),
    sa.Column('quantity', be_kit.databases.NominalField(precision=30, scale=15), nullable=False),
    sa.Column('pk', sa.BigInteger(), nullable=False),
    sa.ForeignKeyConstraint(['movement_id'], ['inventory_product_movement.pk'], name=op.f('fk_inventory_product_movement_item_movement_id_inventory_product_movement'), ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['product_id'], ['inventory_product.pk'], name=op.f('fk_inventory_product_movement_item_product_id_inventory_product'), ondelete='RESTRICT'),
    sa.PrimaryKeyConstraint('pk', name=op.f('pk_inventory_product_movement_item')),
    sa.UniqueConstraint('movement_id', 'product_id', name=op.f('uq_inventory_product_movement_item_movement_id'))
    )
    op.create_table('inventory_product_stock',
    sa.Column('product_id', sa.BigInteger(), nullable=False),
    sa.Column('warehouse_id', sa.BigInteger(), nullable=False),
    sa.Column('available', be_kit.databases.NominalField(precision=30, scale=15), nullable=False),
    sa.Column('reserved', be_kit.databases.NominalField(precision=30, scale=15), nullable=False),
    sa.Column('locked', be_kit.databases.NominalField(precision=30, scale=15), nullable=False),
    sa.Column('organization_id', sa.BigInteger(), nullable=False),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('last_modified_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('created_by_id', sa.BigInteger(), nullable=True),
    sa.Column('last_modified_by_id', sa.BigInteger(), nullable=True),
    sa.Column('pk', sa.BigInteger(), nullable=False),
    sa.ForeignKeyConstraint(['created_by_id'], ['uam_user.pk'], name=op.f('fk_inventory_product_stock_created_by_id_uam_user'), ondelete='SET NULL'),
    sa.ForeignKeyConstraint(['last_modified_by_id'], ['uam_user.pk'], name=op.f('fk_inventory_product_stock_last_modified_by_id_uam_user'), ondelete='SET NULL'),
    sa.ForeignKeyConstraint(['organization_id'], ['uam_organization.pk'], name=op.f('fk_inventory_product_stock_organization_id_uam_organization'), ondelete='RESTRICT'),
    sa.ForeignKeyConstraint(['product_id'], ['inventory_product.pk'], name=op.f('fk_inventory_product_stock_product_id_inventory_product'), ondelete='RESTRICT'),
    sa.ForeignKeyConstraint(['warehouse_id'], ['inventory_warehouse.pk'], name=op.f('fk_inventory_product_stock_warehouse_id_inventory_warehouse'), ondelete='RESTRICT'),
    sa.PrimaryKeyConstraint('pk', name=op.f('pk_inventory_product_stock')),
    sa.UniqueConstraint('organization_id', 'product_id', 'warehouse_id', name=op.f('uq_inventory_product_stock_organization_id'))
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('inventory_product_stock')
    op.drop_table('inventory_product_movement_item')
    op.drop_index(op.f('ix_inventory_product_name'), table_name='inventory_product')
    op.drop_index(op.f('ix_inventory_product_identifier'), table_name='inventory_product')
    op.drop_table('inventory_product')
    op.drop_index(op.f('ix_inventory_product_movement_identifier'), table_name='inventory_product_movement')
    op.drop_table('inventory_product_movement')
    op.drop_index(op.f('ix_inventory_product_category_name'), table_name='inventory_product_category')
    op.drop_table('inventory_product_category')
    op.drop_index(op.f('ix_inventory_warehouse_counter_counter_date'), table_name='inventory_warehouse_counter')
    op.drop_table('inventory_warehouse_counter')
    op.drop_index(op.f('ix_inventory_warehouse_name'), table_name='inventory_warehouse')
    op.drop_index(op.f('ix_inventory_warehouse_identifier'), table_name='inventory_warehouse')
    op.drop_table('inventory_warehouse')
    op.drop_index(op.f('ix_inventory_product_movement_counter_counter_date'), table_name='inventory_product_movement_counter')
    op.drop_table('inventory_product_movement_counter')
    op.drop_index(op.f('ix_inventory_product_counter_counter_date'), table_name='inventory_product_counter')
    op.drop_table('inventory_product_counter')
    # ### end Alembic commands ###
