from be_kit.applications import get_app
from be_uam.application import auth_router
from .settings import settings
from .warehouse.application import router as warehouse_router
from .product.application import (
    product_category_router,
    product_router,
    product_stock_router,
    product_movement_router,
)


app = get_app(settings)

if settings.debug:
    app.include_router(auth_router)

app.include_router(warehouse_router)
app.include_router(product_category_router)
app.include_router(product_router)
app.include_router(product_stock_router)
app.include_router(product_movement_router)
