from typing import Annotated
from fastapi import File, UploadFile
from pydantic import PositiveInt, StringConstraints

from be_kit.paginations import BasePaginatedResponse
from be_kit.schemas import BaseSchema, BaseORMSchema
from be_core_services.contact.schemas import ContactMin
from be_core_services.contact.enums import ContactLegalType, ContactIndustryType
from be_uam.kit.schemas import MetadataMixin
from be_uam.user.schemas import UserMin

class VendorCreate(BaseSchema):
    contact_id: PositiveInt


class Vendor(
    MetadataMixin,
    BaseORMSchema,
):
    contact: ContactMin


class PaginatedVendor(BasePaginatedResponse):
    items: list[Vendor]


class VendorFilter(BaseSchema):
    contact___name__icontains: str | None = None
    contact___legal_type: ContactLegalType | None = None


class VendorMin(BaseORMSchema):
    contact: ContactMin


class VendorOpt(VendorMin):
    pass


class PaginatedVendorOpt(BasePaginatedResponse):
    items: list[VendorOpt]


class VendorIdMixin:
    vendor_id: PositiveInt

class VendorValidator(BaseSchema):
    name: Annotated[str, StringConstraints(min_length=1, max_length=20)]
    tax_id: Annotated[str, StringConstraints(min_length=1, max_length=20)]
    legal_type: ContactLegalType
    industry_type: ContactIndustryType
    address: Annotated[str, StringConstraints(min_length=1, max_length=20)]
    contact_name: Annotated[str, StringConstraints(min_length=1, max_length=50)]
    phone_number: Annotated[str, StringConstraints(min_length=1, max_length=15)]
    contact_email: Annotated[str, StringConstraints(min_length=1, max_length=50)]

class VendorUpload(BaseSchema):
    file: Annotated[UploadFile, File()]

UserMin.model_rebuild()
ContactMin.model_rebuild()
