from sqlalchemy import Select

from be_core_services.contact.models import Contact
from be_kit.repositories import BaseRepository

from . import models


# Vendor


class VendorRepository(BaseRepository):
    model = models.Vendor
    option_fields = ["pk", "contact"]
    filter_by_organization = True

    def add_organization_filter(self, query: Select):
        query = query.filter_by(organization_id=self.organization_id)
        return query

    def add_filters(self, query, filters):
        query = super().add_filters(query, filters)
        query = query.join(Contact, models.Vendor.contact_id == Contact.pk)
        return query
