from sqlalchemy import BigInteger, ForeignKey
from sqlalchemy.orm import Mapped, mapped_column, relationship

from be_core_services.contact.models import Contact
from be_kit.databases import BaseModel, SoftDeleteMixin
from be_uam.kit.models import MetadataMixin
from be_uam.organization.models import OrganizationMixin


class Vendor(OrganizationMixin, SoftDeleteMixin, MetadataMixin, BaseModel):
    __tablename__ = "procurement_vendor"

    contact_id: Mapped[int] = mapped_column(
        BigInteger,
        ForeignKey(f"{Contact.__tablename__}.pk", ondelete="RESTRICT"),
        unique=True,
    )
    contact: Mapped[Contact] = relationship(
        "Contact",
        lazy="selectin",
    )
