# pylint: disable=import-error
# pylint: disable=no-name-in-module
from factory.alchemy import SQLAlchemyModelFactory

# pylint: enable=import-error
# pylint: enable=no-name-in-module
from faker import Faker

from . import models, repositories


faker = Faker()


# pylint: disable=no-member
class BaseCustomerFactory(SQLAlchemyModelFactory):
    organization_id = 1
    created_by_id = 1

    @classmethod
    def _save(cls, model_class, session, args, kwargs):
        obj = super()._save(model_class, session, args, kwargs)
        new_session = cls._meta.sqlalchemy_session_factory()
        repo = repositories.CustomerRepository(
            new_session,
            eager_loads=[
                "organization",
                "created_by",
                "last_modified_by",
                "contact",
            ],
        )
        repo.filter_by_organization = False
        obj = repo.get(obj.pk)
        new_session.close()
        return obj


class BaseCustomerFactoryMeta:
    model = models.Customer


# pylint: enable=no-member
