from enum import StrEnum


class TransactionStatus(StrEnum):
    DRAFT = "Draft"
    APPROVED = "Approved"
    ISSUED = "Issued"
    CANCELLED = "Cancelled"
    COMPLETED = "Completed"


class TransactionPaymentTerm(StrEnum):
    COD = "Cash on Delivery"
    NET_N = "Due in N days"
    EOM = "End of Month"
    EOM_N = "Due N days after end of month"
    ADV = "Advance Payment"
    DP = "Down Payment"
    STAG = "Staggered Payment"


class TransactionDeliveryTerm(StrEnum):
    EXW = "Ex Works"
    FCA = "Free Carrier"
    CPT = "Carried Paid To"
    CIP = "Carriage and Insurance Paid To"
    DAP = "Delivery at Place"
    DPU = "Delivery at Place Unloaded"
    DDP = "Delivery Duty Paid"
    FAS = "Free Alongside Ship"
    FOB = "Free on Board"
    CFR = "Cost and Freight"
