from decimal import Decimal

from pydantic import EmailStr, PositiveInt

from be_kit.paginations import BasePaginatedResponse
from be_kit.schemas import (
    BaseSchema,
    BaseORMSchema,
)
from be_procurement.transaction.enums import (
    TransactionStatus,
    TransactionPaymentTerm,
    TransactionDeliveryTerm,
)
from be_procurement.transaction.schemas import (
    TransactionCreateMixin,
    TransactionUpdateMixin,
    TransactionItemMixin,
    TransactionMixin,
    TransactionFilterMixin,
    TransactionMinMixin,
)
from be_core_services.country.schemas import CurrencyMin, VATMin
from be_inventory.product.schemas import ProductMin
from be_uam.kit.schemas import MetadataMixin
from be_uam.user.schemas import UserMin
from ..vendor.schemas import VendorMin


class VendorWriteMixin:
    vendor_id: PositiveInt


class VendorReadMixin:
    vendor: VendorMin


class RequisitionIdMixin:
    requisition_id: str


class RequisitionCreate(VendorWriteMixin, TransactionCreateMixin, BaseSchema):
    pass


class RequisitionUpdate(VendorWriteMixin, TransactionUpdateMixin, BaseSchema):
    pass


class RequisitionItem(TransactionItemMixin, BaseORMSchema):
    pass


class Requisition(
    VendorReadMixin,
    RequisitionIdMixin,
    TransactionMixin,
    MetadataMixin,
    BaseORMSchema,
):
    items: list[RequisitionItem]


class RequisitionList(
    VendorReadMixin,
    RequisitionIdMixin,
    TransactionMinMixin,
    MetadataMixin,
    BaseORMSchema,
):
    pass


class PaginatedRequisition(BasePaginatedResponse):
    items: list[RequisitionList]


class RequisitionFilter(TransactionFilterMixin, BaseSchema):
    requisition_id__icontains: str | None = None
    vendor___contact___name__icontains: str | None = None


class RequisitionMin(
    VendorReadMixin, RequisitionIdMixin, TransactionMinMixin, BaseORMSchema
):
    pass


class RequisitionOpt(RequisitionMin):
    pass


class PaginatedRequisitionOpt(BasePaginatedResponse):
    items: list[RequisitionOpt]


class RequisitionEmailSend(BaseSchema):
    email: EmailStr


VendorMin.model_rebuild()
ProductMin.model_rebuild()
UserMin.model_rebuild()
CurrencyMin.model_rebuild()
VATMin.model_rebuild()
