from decimal import Decimal

from pydantic import EmailStr, PositiveInt

from be_kit.paginations import BasePaginatedResponse
from be_kit.schemas import (
    BaseSchema,
    BaseORMSchema,
)
from be_procurement.transaction.enums import (
    TransactionStatus,
    TransactionPaymentTerm,
    TransactionDeliveryTerm,
)
from be_procurement.transaction.schemas import (
    TransactionCreateMixin,
    TransactionUpdateMixin,
    TransactionItemMixin,
    TransactionMixin,
    TransactionFilterMixin,
    TransactionMinMixin,
)
from be_core_services.country.schemas import CurrencyMin, VATMin
from be_inventory.product.schemas import ProductMin
from be_uam.kit.schemas import MetadataMixin
from be_uam.user.schemas import UserMin
from ..vendor.schemas import VendorMin


class VendorWriteMixin:
    vendor_id: PositiveInt


class VendorReadMixin:
    vendor: VendorMin


class QuotationIdMixin:
    quotation_id: str


class QuotationCreate(VendorWriteMixin, TransactionCreateMixin, BaseSchema):
    pass


class QuotationUpdate(VendorWriteMixin, TransactionUpdateMixin, BaseSchema):
    pass


class QuotationItem(TransactionItemMixin, BaseORMSchema):
    pass


class Quotation(
    VendorReadMixin,
    QuotationIdMixin,
    TransactionMixin,
    MetadataMixin,
    BaseORMSchema,
):
    items: list[QuotationItem]


class QuotationList(
    VendorReadMixin,
    QuotationIdMixin,
    TransactionMinMixin,
    MetadataMixin,
    BaseORMSchema,
):
    pass


class PaginatedQuotation(BasePaginatedResponse):
    items: list[QuotationList]


class QuotationFilter(TransactionFilterMixin, BaseSchema):
    quotation_id__icontains: str | None = None
    vendor___contact___name__icontains: str | None = None


class QuotationMin(
    VendorReadMixin, QuotationIdMixin, TransactionMinMixin, BaseORMSchema
):
    pass


class QuotationOpt(QuotationMin):
    pass


class PaginatedQuotationOpt(BasePaginatedResponse):
    items: list[QuotationOpt]


class QuotationEmailSend(BaseSchema):
    email: EmailStr


VendorMin.model_rebuild()
ProductMin.model_rebuild()
UserMin.model_rebuild()
CurrencyMin.model_rebuild()
VATMin.model_rebuild()
