from be_uam.permission.utils import generate_permission_list


permissions = generate_permission_list(
    app="procurement",
    module="quotation",
    submodule="quotation",
    action=[
        "create",
        "read",
        "update",
        "delete",
        "approve",
        "send_email",
        "cancel",
    ],
)


quotation_permission_mapper = {
    "create_quotation": ["procurement.quotation.quotation.create"],
    "retrieve_quotation": ["procurement.quotation.quotation.read"],
    "list_quotation": ["procurement.quotation.quotation.read"],
    "list_quotation_option": ["procurement.quotation.quotation.read"],
    "update_quotation": ["procurement.quotation.quotation.update"],
    "delete_quotation": ["procurement.quotation.quotation.delete"],
    "approve_quotation": ["procurement.quotation.quotation.approve"],
    "send_quotation_email": ["procurement.quotation.quotation.send_email"],
    "cancel_quotation": ["procurement.quotation.quotation.cancel"],
}
