from decimal import Decimal
from typing import Any

from pydantic import (
    EmailStr,
    PositiveFloat,
    PositiveInt,
    computed_field,
    model_validator,
)
from be_kit.schemas import BaseORMSchema, BaseSchema
from be_core_services.country.schemas import CurrencyMin
from be_crm.customer.schemas import CustomerMin
from be_uam.user.schemas import UserMin
from be_uam.kit.schemas import MetadataMixin


from datetime import date
from decimal import Decimal
from typing import Optional

from be_procurement.vendor.schemas import VendorMin

from be_procurement.invoice.schemas import InvoiceMin
from . import enums


class Payment(MetadataMixin, BaseORMSchema):
    vendor: Optional[VendorMin] = None
    amount: Decimal
    status: enums.PaymentStatus
    payment_type: enums.PaymentType
    notes: Optional[str] = None
    payment_date: date
    currency: CurrencyMin
    invoice: InvoiceMin

class PaymentCreateUpdate(BaseSchema):
    vendor_id: Optional[int] = None
    invoice_id: Optional[int] = None
    amount: Decimal
    status: enums.PaymentStatus
    payment_type: enums.PaymentType
    notes: Optional[str] = None
    payment_date: date
    currency_id: int

class PaymentCreate(PaymentCreateUpdate):
    pass

class PaymentUpdate(PaymentCreateUpdate):
    pass

class PaymentFilter(BaseSchema):
    customer_id: Optional[int] = None
    status: Optional[enums.PaymentStatus] = None
    payment_type: Optional[enums.PaymentType] = None

class PaymentMin(BaseORMSchema):
    vendor: Optional[VendorMin] = None
    amount: Decimal
    status: enums.PaymentStatus
    payment_type: enums.PaymentType
    payment_date: date
    currency: CurrencyMin
    invoice: InvoiceMin

class PaginatedPayment(BaseSchema):
    items: list[Payment]

class PaginatedPaymentOpt(BaseSchema):
    items: list[Payment]


VendorMin.model_rebuild()
UserMin.model_rebuild()
CurrencyMin.model_rebuild()
InvoiceMin.model_rebuild()

