from be_uam.permission.utils import generate_permission_list


permissions = generate_permission_list(
    app="procurement",
    module="payment",
    submodule="payment",
    action=[
        "create",
        "read",
        "update",
        "delete",
        "approve",
        "cancel",
    ],
)


payment_permission_mapper = {
    "create_payment": ["procurement.payment.payment.create"],
    "retrieve_payment": ["procurement.payment.payment.read"],
    "list_payment": ["procurement.payment.payment.read"],
    "list_payment_option": ["procurement.payment.payment.read"],
    "update_payment": ["procurement.payment.payment.update"],
    "delete_payment": ["procurement.payment.payment.delete"],
    "approve_payment": ["procurement.payment.payment.approve"],
    "cancel_payment": ["procurement.payment.payment.cancel"],
}
