from enum import StrEnum

from be_kit.enums import StrEnumWithMixins
from be_uam.kit.enums import MetadataOrderingMixin

class PaymentType(StrEnum):
    CASH = "Cash"
    BANK = "Bank"


class PaymentStatus(StrEnum):
    DRAFT = "Draft"
    INPAYMENT = "Inpayment"
    PAID = "Paid"
    REJECTED = "Rejected"


class PaymentOrdering(MetadataOrderingMixin, StrEnumWithMixins):
    pass
