"""procurement: fix payment

Revision ID: e59dae5b280f
Revises: d3cd61063439
Create Date: 2025-11-26 11:09:34.619257

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import mysql

# revision identifiers, used by Alembic.
revision: str = 'e59dae5b280f'
down_revision: Union[str, None] = 'd3cd61063439'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('procurement_payment', sa.Column('invoice_id', sa.BigInteger(), nullable=True))
    op.drop_constraint('fk_procurement_payment_procurement_invoice_id_procuremen_853a', 'procurement_payment', type_='foreignkey')
    op.create_foreign_key(op.f('fk_procurement_payment_invoice_id_procurement_invoice'), 'procurement_payment', 'procurement_invoice', ['invoice_id'], ['pk'], ondelete='RESTRICT')
    op.drop_column('procurement_payment', 'procurement_invoice_id')
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('procurement_payment', sa.Column('procurement_invoice_id', mysql.BIGINT(), autoincrement=False, nullable=True))
    op.drop_constraint(op.f('fk_procurement_payment_invoice_id_procurement_invoice'), 'procurement_payment', type_='foreignkey')
    op.create_foreign_key('fk_procurement_payment_procurement_invoice_id_procuremen_853a', 'procurement_payment', 'procurement_invoice', ['procurement_invoice_id'], ['pk'], ondelete='RESTRICT')
    op.drop_column('procurement_payment', 'invoice_id')
    # ### end Alembic commands ###
