"""procurement: added payment

Revision ID: d3cd61063439
Revises: eb2502d9c2a5
Create Date: 2025-11-26 11:07:13.392426

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = 'd3cd61063439'
down_revision: Union[str, None] = 'eb2502d9c2a5'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('procurement_payment_counter',
    sa.Column('counter_date', sa.Date(), nullable=False),
    sa.Column('counter', sa.BigInteger(), nullable=False),
    sa.Column('organization_id', sa.BigInteger(), nullable=False),
    sa.Column('pk', sa.BigInteger(), nullable=False),
    sa.ForeignKeyConstraint(['organization_id'], ['uam_organization.pk'], name=op.f('fk_procurement_payment_counter_organization_id_uam_organization'), ondelete='RESTRICT'),
    sa.PrimaryKeyConstraint('pk', name=op.f('pk_procurement_payment_counter')),
    sa.UniqueConstraint('organization_id', 'counter_date', name='uq_procurement_payment_counter_organization_id_counter_date')
    )
    op.create_table('procurement_payment',
    sa.Column('vendor_id', sa.BigInteger(), nullable=True),
    sa.Column('amount', sa.Numeric(precision=20, scale=4), nullable=False),
    sa.Column('status', sa.Enum('DRAFT', 'INPAYMENT', 'PAID', 'REJECTED', name='paymentstatus'), nullable=False),
    sa.Column('payment_type', sa.Enum('CASH', 'BANK', name='paymenttype'), nullable=False),
    sa.Column('memo', sa.String(length=255), nullable=True),
    sa.Column('payment_date', sa.Date(), nullable=False),
    sa.Column('approved_by_id', sa.BigInteger(), nullable=True),
    sa.Column('currency_id', sa.BigInteger(), nullable=False),
    sa.Column('procurement_invoice_id', sa.BigInteger(), nullable=True),
    sa.Column('organization_id', sa.BigInteger(), nullable=False),
    sa.Column('deleted_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('last_modified_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('created_by_id', sa.BigInteger(), nullable=True),
    sa.Column('last_modified_by_id', sa.BigInteger(), nullable=True),
    sa.Column('pk', sa.BigInteger(), nullable=False),
    sa.ForeignKeyConstraint(['approved_by_id'], ['uam_user.pk'], name=op.f('fk_procurement_payment_approved_by_id_uam_user'), ondelete='SET NULL'),
    sa.ForeignKeyConstraint(['created_by_id'], ['uam_user.pk'], name=op.f('fk_procurement_payment_created_by_id_uam_user'), ondelete='SET NULL'),
    sa.ForeignKeyConstraint(['currency_id'], ['core_services_currency.pk'], name=op.f('fk_procurement_payment_currency_id_core_services_currency'), ondelete='RESTRICT'),
    sa.ForeignKeyConstraint(['last_modified_by_id'], ['uam_user.pk'], name=op.f('fk_procurement_payment_last_modified_by_id_uam_user'), ondelete='SET NULL'),
    sa.ForeignKeyConstraint(['organization_id'], ['uam_organization.pk'], name=op.f('fk_procurement_payment_organization_id_uam_organization'), ondelete='RESTRICT'),
    sa.ForeignKeyConstraint(['procurement_invoice_id'], ['procurement_invoice.pk'], name=op.f('fk_procurement_payment_procurement_invoice_id_procurement_invoice'), ondelete='RESTRICT'),
    sa.ForeignKeyConstraint(['vendor_id'], ['procurement_vendor.pk'], name=op.f('fk_procurement_payment_vendor_id_procurement_vendor'), ondelete='RESTRICT'),
    sa.PrimaryKeyConstraint('pk', name=op.f('pk_procurement_payment'))
    )
    op.create_index(op.f('ix_procurement_payment_payment_type'), 'procurement_payment', ['payment_type'], unique=False)
    op.create_index(op.f('ix_procurement_payment_status'), 'procurement_payment', ['status'], unique=False)
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f('ix_procurement_payment_status'), table_name='procurement_payment')
    op.drop_index(op.f('ix_procurement_payment_payment_type'), table_name='procurement_payment')
    op.drop_table('procurement_payment')
    op.drop_table('procurement_payment_counter')
    # ### end Alembic commands ###
