"""procurement: added linkage to product movement from order and invoice to payment

Revision ID: 5e7a202c1a68
Revises: 3b6152b54dee
Create Date: 2025-11-26 10:38:19.692327

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = '5e7a202c1a68'
down_revision: Union[str, None] = '3b6152b54dee'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('procurement_order', sa.Column('product_movement_id', sa.BigInteger(), nullable=True))
    op.create_foreign_key(op.f('fk_procurement_order_product_movement_id_inventory_product_movement'), 'procurement_order', 'inventory_product_movement', ['product_movement_id'], ['pk'], ondelete='RESTRICT')
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(op.f('fk_procurement_order_product_movement_id_inventory_product_movement'), 'procurement_order', type_='foreignkey')
    op.drop_column('procurement_order', 'product_movement_id')
    # ### end Alembic commands ###
