"""procurement: added warehouse

Revision ID: 3b6152b54dee
Revises: 256a6ef476e6
Create Date: 2025-11-04 16:09:08.982071

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import mysql

# revision identifiers, used by Alembic.
revision: str = '3b6152b54dee'
down_revision: Union[str, None] = '256a6ef476e6'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('procurement_invoice', sa.Column('untaxed_subtotal', sa.Numeric(precision=20, scale=4), nullable=True))
    op.add_column('procurement_invoice', sa.Column('global_discount', sa.Numeric(precision=20, scale=4), nullable=True))
    op.add_column('procurement_invoice', sa.Column('tax_value', sa.Numeric(precision=20, scale=4), nullable=True))
    op.add_column('procurement_invoice', sa.Column('discount_per_item', sa.Numeric(precision=20, scale=4), nullable=True))
    op.add_column('procurement_invoice', sa.Column('grand_total', sa.Numeric(precision=20, scale=4), nullable=True))
    op.add_column('procurement_invoice', sa.Column('global_dp', sa.Numeric(precision=20, scale=4), nullable=True))
    op.add_column('procurement_order_item', sa.Column('warehouse_id', sa.BigInteger(), nullable=False))
    op.create_foreign_key(op.f('fk_procurement_order_item_warehouse_id_inventory_warehouse'), 'procurement_order_item', 'inventory_warehouse', ['warehouse_id'], ['pk'], ondelete='RESTRICT')
    op.drop_column('procurement_order_item', 'subtotal')
    op.add_column('procurement_quotation_item', sa.Column('warehouse_id', sa.BigInteger(), nullable=False))
    op.create_foreign_key(op.f('fk_procurement_quotation_item_warehouse_id_inventory_warehouse'), 'procurement_quotation_item', 'inventory_warehouse', ['warehouse_id'], ['pk'], ondelete='RESTRICT')
    op.drop_column('procurement_quotation_item', 'subtotal')
    op.add_column('procurement_requisition_item', sa.Column('warehouse_id', sa.BigInteger(), nullable=False))
    op.create_foreign_key(op.f('fk_procurement_requisition_item_warehouse_id_inventory_warehouse'), 'procurement_requisition_item', 'inventory_warehouse', ['warehouse_id'], ['pk'], ondelete='RESTRICT')
    op.drop_column('procurement_requisition_item', 'subtotal')
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('procurement_requisition_item', sa.Column('subtotal', mysql.DECIMAL(precision=20, scale=4), nullable=True))
    op.drop_constraint(op.f('fk_procurement_requisition_item_warehouse_id_inventory_warehouse'), 'procurement_requisition_item', type_='foreignkey')
    op.drop_column('procurement_requisition_item', 'warehouse_id')
    op.add_column('procurement_quotation_item', sa.Column('subtotal', mysql.DECIMAL(precision=20, scale=4), nullable=True))
    op.drop_constraint(op.f('fk_procurement_quotation_item_warehouse_id_inventory_warehouse'), 'procurement_quotation_item', type_='foreignkey')
    op.drop_column('procurement_quotation_item', 'warehouse_id')
    op.add_column('procurement_order_item', sa.Column('subtotal', mysql.DECIMAL(precision=20, scale=4), nullable=True))
    op.drop_constraint(op.f('fk_procurement_order_item_warehouse_id_inventory_warehouse'), 'procurement_order_item', type_='foreignkey')
    op.drop_column('procurement_order_item', 'warehouse_id')
    op.drop_column('procurement_invoice', 'global_dp')
    op.drop_column('procurement_invoice', 'grand_total')
    op.drop_column('procurement_invoice', 'discount_per_item')
    op.drop_column('procurement_invoice', 'tax_value')
    op.drop_column('procurement_invoice', 'global_discount')
    op.drop_column('procurement_invoice', 'untaxed_subtotal')
    # ### end Alembic commands ###
