"""procurement: refactored procurement

Revision ID: 256a6ef476e6
Revises: 6bbbfd9f3ac3
Create Date: 2025-10-28 11:09:37.658842

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import mysql

# revision identifiers, used by Alembic.
revision: str = '256a6ef476e6'
down_revision: Union[str, None] = '6bbbfd9f3ac3'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint('fk_procurement_invoice_organization_id_uam_organization', 'procurement_invoice', type_='foreignkey')
    op.create_foreign_key(op.f('fk_procurement_invoice_organization_id_uam_organization'), 'procurement_invoice', 'uam_organization', ['organization_id'], ['pk'], ondelete='RESTRICT')
    op.drop_constraint('fk_procurement_invoice_counter_organization_id_uam_organization', 'procurement_invoice_counter', type_='foreignkey')
    op.create_foreign_key(op.f('fk_procurement_invoice_counter_organization_id_uam_organization'), 'procurement_invoice_counter', 'uam_organization', ['organization_id'], ['pk'], ondelete='RESTRICT')
    op.add_column('procurement_order', sa.Column('total_after_tax_and_discount', sa.Numeric(precision=20, scale=4), nullable=True))
    op.add_column('procurement_order', sa.Column('untaxed_subtotal', sa.Numeric(precision=20, scale=4), nullable=True))
    op.add_column('procurement_order', sa.Column('global_discount', sa.Numeric(precision=20, scale=4), nullable=True))
    op.add_column('procurement_order', sa.Column('tax_value', sa.Numeric(precision=20, scale=4), nullable=True))
    op.add_column('procurement_order', sa.Column('discount_per_item', sa.Numeric(precision=20, scale=4), nullable=True))
    op.add_column('procurement_order', sa.Column('grand_total', sa.Numeric(precision=20, scale=4), nullable=True))
    op.add_column('procurement_order', sa.Column('global_dp', sa.Numeric(precision=20, scale=4), nullable=True))
    op.alter_column('procurement_order', 'total',
               existing_type=mysql.DECIMAL(precision=20, scale=4),
               nullable=True)
    op.drop_constraint('fk_procurement_order_organization_id_uam_organization', 'procurement_order', type_='foreignkey')
    op.create_foreign_key(op.f('fk_procurement_order_organization_id_uam_organization'), 'procurement_order', 'uam_organization', ['organization_id'], ['pk'], ondelete='RESTRICT')
    op.drop_constraint('fk_procurement_order_counter_organization_id_uam_organization', 'procurement_order_counter', type_='foreignkey')
    op.create_foreign_key(op.f('fk_procurement_order_counter_organization_id_uam_organization'), 'procurement_order_counter', 'uam_organization', ['organization_id'], ['pk'], ondelete='RESTRICT')
    op.add_column('procurement_order_item', sa.Column('subtotal', sa.Numeric(precision=20, scale=4), nullable=True))
    op.add_column('procurement_quotation', sa.Column('total_after_tax_and_discount', sa.Numeric(precision=20, scale=4), nullable=True))
    op.add_column('procurement_quotation', sa.Column('untaxed_subtotal', sa.Numeric(precision=20, scale=4), nullable=True))
    op.add_column('procurement_quotation', sa.Column('global_discount', sa.Numeric(precision=20, scale=4), nullable=True))
    op.add_column('procurement_quotation', sa.Column('tax_value', sa.Numeric(precision=20, scale=4), nullable=True))
    op.add_column('procurement_quotation', sa.Column('discount_per_item', sa.Numeric(precision=20, scale=4), nullable=True))
    op.add_column('procurement_quotation', sa.Column('grand_total', sa.Numeric(precision=20, scale=4), nullable=True))
    op.add_column('procurement_quotation', sa.Column('global_dp', sa.Numeric(precision=20, scale=4), nullable=True))
    op.alter_column('procurement_quotation', 'total',
               existing_type=mysql.DECIMAL(precision=20, scale=4),
               nullable=True)
    op.drop_constraint('fk_procurement_quotation_organization_id_uam_organization', 'procurement_quotation', type_='foreignkey')
    op.create_foreign_key(op.f('fk_procurement_quotation_organization_id_uam_organization'), 'procurement_quotation', 'uam_organization', ['organization_id'], ['pk'], ondelete='RESTRICT')
    op.drop_constraint('fk_procurement_quotation_counter_organization_id_uam_org_e52f', 'procurement_quotation_counter', type_='foreignkey')
    op.create_foreign_key(op.f('fk_procurement_quotation_counter_organization_id_uam_organization'), 'procurement_quotation_counter', 'uam_organization', ['organization_id'], ['pk'], ondelete='RESTRICT')
    op.add_column('procurement_quotation_item', sa.Column('subtotal', sa.Numeric(precision=20, scale=4), nullable=True))
    op.add_column('procurement_requisition', sa.Column('total_after_tax_and_discount', sa.Numeric(precision=20, scale=4), nullable=True))
    op.add_column('procurement_requisition', sa.Column('untaxed_subtotal', sa.Numeric(precision=20, scale=4), nullable=True))
    op.add_column('procurement_requisition', sa.Column('global_discount', sa.Numeric(precision=20, scale=4), nullable=True))
    op.add_column('procurement_requisition', sa.Column('tax_value', sa.Numeric(precision=20, scale=4), nullable=True))
    op.add_column('procurement_requisition', sa.Column('discount_per_item', sa.Numeric(precision=20, scale=4), nullable=True))
    op.add_column('procurement_requisition', sa.Column('grand_total', sa.Numeric(precision=20, scale=4), nullable=True))
    op.add_column('procurement_requisition', sa.Column('global_dp', sa.Numeric(precision=20, scale=4), nullable=True))
    op.alter_column('procurement_requisition', 'total',
               existing_type=mysql.DECIMAL(precision=20, scale=4),
               nullable=True)
    op.drop_constraint('fk_procurement_requisition_organization_id_uam_organization', 'procurement_requisition', type_='foreignkey')
    op.create_foreign_key(op.f('fk_procurement_requisition_organization_id_uam_organization'), 'procurement_requisition', 'uam_organization', ['organization_id'], ['pk'], ondelete='RESTRICT')
    op.drop_constraint('fk_procurement_requisition_counter_organization_id_uam_o_7d3c', 'procurement_requisition_counter', type_='foreignkey')
    op.create_foreign_key(op.f('fk_procurement_requisition_counter_organization_id_uam_organization'), 'procurement_requisition_counter', 'uam_organization', ['organization_id'], ['pk'], ondelete='RESTRICT')
    op.add_column('procurement_requisition_item', sa.Column('subtotal', sa.Numeric(precision=20, scale=4), nullable=True))
    op.drop_constraint('fk_procurement_vendor_organization_id_uam_organization', 'procurement_vendor', type_='foreignkey')
    op.create_foreign_key(op.f('fk_procurement_vendor_organization_id_uam_organization'), 'procurement_vendor', 'uam_organization', ['organization_id'], ['pk'], ondelete='RESTRICT')
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(op.f('fk_procurement_vendor_organization_id_uam_organization'), 'procurement_vendor', type_='foreignkey')
    op.create_foreign_key('fk_procurement_vendor_organization_id_uam_organization', 'procurement_vendor', 'uam_organization', ['organization_id'], ['pk'], ondelete='CASCADE')
    op.drop_column('procurement_requisition_item', 'subtotal')
    op.drop_constraint(op.f('fk_procurement_requisition_counter_organization_id_uam_organization'), 'procurement_requisition_counter', type_='foreignkey')
    op.create_foreign_key('fk_procurement_requisition_counter_organization_id_uam_o_7d3c', 'procurement_requisition_counter', 'uam_organization', ['organization_id'], ['pk'], ondelete='CASCADE')
    op.drop_constraint(op.f('fk_procurement_requisition_organization_id_uam_organization'), 'procurement_requisition', type_='foreignkey')
    op.create_foreign_key('fk_procurement_requisition_organization_id_uam_organization', 'procurement_requisition', 'uam_organization', ['organization_id'], ['pk'], ondelete='CASCADE')
    op.alter_column('procurement_requisition', 'total',
               existing_type=mysql.DECIMAL(precision=20, scale=4),
               nullable=False)
    op.drop_column('procurement_requisition', 'global_dp')
    op.drop_column('procurement_requisition', 'grand_total')
    op.drop_column('procurement_requisition', 'discount_per_item')
    op.drop_column('procurement_requisition', 'tax_value')
    op.drop_column('procurement_requisition', 'global_discount')
    op.drop_column('procurement_requisition', 'untaxed_subtotal')
    op.drop_column('procurement_requisition', 'total_after_tax_and_discount')
    op.drop_column('procurement_quotation_item', 'subtotal')
    op.drop_constraint(op.f('fk_procurement_quotation_counter_organization_id_uam_organization'), 'procurement_quotation_counter', type_='foreignkey')
    op.create_foreign_key('fk_procurement_quotation_counter_organization_id_uam_org_e52f', 'procurement_quotation_counter', 'uam_organization', ['organization_id'], ['pk'], ondelete='CASCADE')
    op.drop_constraint(op.f('fk_procurement_quotation_organization_id_uam_organization'), 'procurement_quotation', type_='foreignkey')
    op.create_foreign_key('fk_procurement_quotation_organization_id_uam_organization', 'procurement_quotation', 'uam_organization', ['organization_id'], ['pk'], ondelete='CASCADE')
    op.alter_column('procurement_quotation', 'total',
               existing_type=mysql.DECIMAL(precision=20, scale=4),
               nullable=False)
    op.drop_column('procurement_quotation', 'global_dp')
    op.drop_column('procurement_quotation', 'grand_total')
    op.drop_column('procurement_quotation', 'discount_per_item')
    op.drop_column('procurement_quotation', 'tax_value')
    op.drop_column('procurement_quotation', 'global_discount')
    op.drop_column('procurement_quotation', 'untaxed_subtotal')
    op.drop_column('procurement_quotation', 'total_after_tax_and_discount')
    op.drop_column('procurement_order_item', 'subtotal')
    op.drop_constraint(op.f('fk_procurement_order_counter_organization_id_uam_organization'), 'procurement_order_counter', type_='foreignkey')
    op.create_foreign_key('fk_procurement_order_counter_organization_id_uam_organization', 'procurement_order_counter', 'uam_organization', ['organization_id'], ['pk'], ondelete='CASCADE')
    op.drop_constraint(op.f('fk_procurement_order_organization_id_uam_organization'), 'procurement_order', type_='foreignkey')
    op.create_foreign_key('fk_procurement_order_organization_id_uam_organization', 'procurement_order', 'uam_organization', ['organization_id'], ['pk'], ondelete='CASCADE')
    op.alter_column('procurement_order', 'total',
               existing_type=mysql.DECIMAL(precision=20, scale=4),
               nullable=False)
    op.drop_column('procurement_order', 'global_dp')
    op.drop_column('procurement_order', 'grand_total')
    op.drop_column('procurement_order', 'discount_per_item')
    op.drop_column('procurement_order', 'tax_value')
    op.drop_column('procurement_order', 'global_discount')
    op.drop_column('procurement_order', 'untaxed_subtotal')
    op.drop_column('procurement_order', 'total_after_tax_and_discount')
    op.drop_constraint(op.f('fk_procurement_invoice_counter_organization_id_uam_organization'), 'procurement_invoice_counter', type_='foreignkey')
    op.create_foreign_key('fk_procurement_invoice_counter_organization_id_uam_organization', 'procurement_invoice_counter', 'uam_organization', ['organization_id'], ['pk'], ondelete='CASCADE')
    op.drop_constraint(op.f('fk_procurement_invoice_organization_id_uam_organization'), 'procurement_invoice', type_='foreignkey')
    op.create_foreign_key('fk_procurement_invoice_organization_id_uam_organization', 'procurement_invoice', 'uam_organization', ['organization_id'], ['pk'], ondelete='CASCADE')
    # ### end Alembic commands ###
