"""procurement: populate requisition permissions

Revision ID: 6bbbfd9f3ac3
Revises: be7f009bdcf4
Create Date: 2025-03-17 11:04:42.450592

"""

from typing import Sequence, Union

from alembic import op
from sqlalchemy.orm import Session
from be_uam.permission.utils import populate_permissions
from be_procurement.permissions import permissions


# revision identifiers, used by Alembic.
revision: str = "6bbbfd9f3ac3"
down_revision: Union[str, None] = "be7f009bdcf4"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    db = Session(bind=op.get_bind())
    populate_permissions(db, permissions)
    db.close()


def downgrade() -> None:
    pass
