"""procurement: populate initial permissions

Revision ID: be7f009bdcf4
Revises: 4c11b707d56c
Create Date: 2025-03-16 09:51:14.195312

"""

from typing import Sequence, Union

from alembic import op
from sqlalchemy.orm import Session
from be_uam.permission.utils import populate_permissions
from be_procurement.permissions import permissions


# revision identifiers, used by Alembic.
revision: str = "be7f009bdcf4"
down_revision: Union[str, None] = "4c11b707d56c"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    db = Session(bind=op.get_bind())
    populate_permissions(db, permissions)
    db.close()


def downgrade() -> None:
    pass
