"""procurement: initial migrations

Revision ID: 4c11b707d56c
Revises:
Create Date: 2025-03-16 09:50:23.144194

"""

from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision: str = "4c11b707d56c"
down_revision: Union[str, None] = None
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "procurement_invoice_counter",
        sa.Column("counter_date", sa.Date(), nullable=False),
        sa.Column("counter", sa.BigInteger(), nullable=False),
        sa.Column("organization_id", sa.BigInteger(), nullable=False),
        sa.Column(
            "pk", sa.BigInteger(), sa.Identity(always=False, cycle=True), nullable=False
        ),
        sa.ForeignKeyConstraint(
            ["organization_id"],
            ["uam_organization.pk"],
            name=op.f(
                "fk_procurement_invoice_counter_organization_id_uam_organization"
            ),
            ondelete="CASCADE",
        ),
        sa.PrimaryKeyConstraint("pk", name=op.f("pk_procurement_invoice_counter")),
        sa.UniqueConstraint(
            "organization_id",
            "counter_date",
            name="uq_procurement_invoice_counter_organization_id_counter_date",
        ),
    )
    op.create_table(
        "procurement_order_counter",
        sa.Column("counter_date", sa.Date(), nullable=False),
        sa.Column("counter", sa.BigInteger(), nullable=False),
        sa.Column("organization_id", sa.BigInteger(), nullable=False),
        sa.Column(
            "pk", sa.BigInteger(), sa.Identity(always=False, cycle=True), nullable=False
        ),
        sa.ForeignKeyConstraint(
            ["organization_id"],
            ["uam_organization.pk"],
            name=op.f("fk_procurement_order_counter_organization_id_uam_organization"),
            ondelete="CASCADE",
        ),
        sa.PrimaryKeyConstraint("pk", name=op.f("pk_procurement_order_counter")),
        sa.UniqueConstraint(
            "organization_id",
            "counter_date",
            name="uq_procurement_order_counter_organization_id_counter_date",
        ),
    )
    op.create_table(
        "procurement_quotation_counter",
        sa.Column("counter_date", sa.Date(), nullable=False),
        sa.Column("counter", sa.BigInteger(), nullable=False),
        sa.Column("organization_id", sa.BigInteger(), nullable=False),
        sa.Column(
            "pk", sa.BigInteger(), sa.Identity(always=False, cycle=True), nullable=False
        ),
        sa.ForeignKeyConstraint(
            ["organization_id"],
            ["uam_organization.pk"],
            name=op.f(
                "fk_procurement_quotation_counter_organization_id_uam_organization"
            ),
            ondelete="CASCADE",
        ),
        sa.PrimaryKeyConstraint("pk", name=op.f("pk_procurement_quotation_counter")),
        sa.UniqueConstraint(
            "organization_id",
            "counter_date",
            name="uq_procurement_quotation_counter_organization_id_counter_date",
        ),
    )
    op.create_table(
        "procurement_requisition_counter",
        sa.Column("counter_date", sa.Date(), nullable=False),
        sa.Column("counter", sa.BigInteger(), nullable=False),
        sa.Column("organization_id", sa.BigInteger(), nullable=False),
        sa.Column(
            "pk", sa.BigInteger(), sa.Identity(always=False, cycle=True), nullable=False
        ),
        sa.ForeignKeyConstraint(
            ["organization_id"],
            ["uam_organization.pk"],
            name=op.f(
                "fk_procurement_requisition_counter_organization_id_uam_organization"
            ),
            ondelete="CASCADE",
        ),
        sa.PrimaryKeyConstraint("pk", name=op.f("pk_procurement_requisition_counter")),
        sa.UniqueConstraint(
            "organization_id",
            "counter_date",
            name="uq_procurement_requisition_counter_organization_id_counter_date",
        ),
    )
    op.create_table(
        "procurement_vendor",
        sa.Column("contact_id", sa.BigInteger(), nullable=False),
        sa.Column("organization_id", sa.BigInteger(), nullable=False),
        sa.Column("deleted_at", sa.DateTime(timezone=True), nullable=True),
        sa.Column(
            "created_at",
            sa.DateTime(timezone=True),
            server_default=sa.text("now()"),
            nullable=False,
        ),
        sa.Column(
            "last_modified_at",
            sa.DateTime(timezone=True),
            server_default=sa.text("now()"),
            nullable=False,
        ),
        sa.Column("created_by_id", sa.BigInteger(), nullable=True),
        sa.Column("last_modified_by_id", sa.BigInteger(), nullable=True),
        sa.Column(
            "pk", sa.BigInteger(), sa.Identity(always=False, cycle=True), nullable=False
        ),
        sa.ForeignKeyConstraint(
            ["contact_id"],
            ["core_services_contact.pk"],
            name=op.f("fk_procurement_vendor_contact_id_core_services_contact"),
            ondelete="RESTRICT",
        ),
        sa.ForeignKeyConstraint(
            ["created_by_id"],
            ["uam_user.pk"],
            name=op.f("fk_procurement_vendor_created_by_id_uam_user"),
            ondelete="SET NULL",
        ),
        sa.ForeignKeyConstraint(
            ["last_modified_by_id"],
            ["uam_user.pk"],
            name=op.f("fk_procurement_vendor_last_modified_by_id_uam_user"),
            ondelete="SET NULL",
        ),
        sa.ForeignKeyConstraint(
            ["organization_id"],
            ["uam_organization.pk"],
            name=op.f("fk_procurement_vendor_organization_id_uam_organization"),
            ondelete="CASCADE",
        ),
        sa.PrimaryKeyConstraint("pk", name=op.f("pk_procurement_vendor")),
        sa.UniqueConstraint(
            "contact_id", name=op.f("uq_procurement_vendor_contact_id")
        ),
    )
    op.create_table(
        "procurement_quotation",
        sa.Column("quotation_id", sa.String(length=11), nullable=False),
        sa.Column("vendor_id", sa.BigInteger(), nullable=False),
        sa.Column(
            "status",
            postgresql.ENUM(
                "DRAFT",
                "APPROVED",
                "ISSUED",
                "CANCELLED",
                "COMPLETED",
                name="transactionstatus",
                create_type=False,
            ),
            nullable=False,
        ),
        sa.Column(
            "payment_term",
            postgresql.ENUM(
                "COD",
                "NET_N",
                "EOM",
                "EOM_N",
                "ADV",
                "DP",
                "STAG",
                name="transactionpaymentterm",
                create_type=False,
            ),
            nullable=False,
        ),
        sa.Column("payment_n", sa.Integer(), nullable=True),
        sa.Column("payment_dp_rate", sa.Numeric(precision=5, scale=4), nullable=True),
        sa.Column("payment_dp", sa.Numeric(precision=20, scale=4), nullable=True),
        sa.Column(
            "delivery_term",
            postgresql.ENUM(
                "EXW",
                "FCA",
                "CPT",
                "CIP",
                "DAP",
                "DPU",
                "DDP",
                "FAS",
                "FOB",
                "CFR",
                name="transactiondeliveryterm",
                create_type=False,
            ),
            nullable=True,
        ),
        sa.Column("discount_rate", sa.Numeric(precision=5, scale=4), nullable=True),
        sa.Column("discount_amount", sa.Numeric(precision=20, scale=4), nullable=True),
        sa.Column("total", sa.Numeric(precision=20, scale=4), nullable=False),
        sa.Column("total_discount", sa.Numeric(precision=20, scale=4), nullable=False),
        sa.Column(
            "total_global_discount", sa.Numeric(precision=20, scale=4), nullable=True
        ),
        sa.Column("total_before_vat", sa.Numeric(precision=20, scale=4), nullable=True),
        sa.Column("total_vat", sa.Numeric(precision=20, scale=4), nullable=False),
        sa.Column("total_net", sa.Numeric(precision=20, scale=4), nullable=False),
        sa.Column(
            "total_net_after_dp", sa.Numeric(precision=20, scale=4), nullable=True
        ),
        sa.Column("notes", sa.String(length=255), nullable=True),
        sa.Column("currency_id", sa.BigInteger(), nullable=False),
        sa.Column("approved_by_id", sa.BigInteger(), nullable=True),
        sa.Column("organization_id", sa.BigInteger(), nullable=False),
        sa.Column("deleted_at", sa.DateTime(timezone=True), nullable=True),
        sa.Column(
            "created_at",
            sa.DateTime(timezone=True),
            server_default=sa.text("now()"),
            nullable=False,
        ),
        sa.Column(
            "last_modified_at",
            sa.DateTime(timezone=True),
            server_default=sa.text("now()"),
            nullable=False,
        ),
        sa.Column("created_by_id", sa.BigInteger(), nullable=True),
        sa.Column("last_modified_by_id", sa.BigInteger(), nullable=True),
        sa.Column(
            "pk", sa.BigInteger(), sa.Identity(always=False, cycle=True), nullable=False
        ),
        sa.ForeignKeyConstraint(
            ["approved_by_id"],
            ["uam_user.pk"],
            name=op.f("fk_procurement_quotation_approved_by_id_uam_user"),
            ondelete="SET NULL",
        ),
        sa.ForeignKeyConstraint(
            ["created_by_id"],
            ["uam_user.pk"],
            name=op.f("fk_procurement_quotation_created_by_id_uam_user"),
            ondelete="SET NULL",
        ),
        sa.ForeignKeyConstraint(
            ["currency_id"],
            ["core_services_currency.pk"],
            name=op.f("fk_procurement_quotation_currency_id_core_services_currency"),
            ondelete="RESTRICT",
        ),
        sa.ForeignKeyConstraint(
            ["last_modified_by_id"],
            ["uam_user.pk"],
            name=op.f("fk_procurement_quotation_last_modified_by_id_uam_user"),
            ondelete="SET NULL",
        ),
        sa.ForeignKeyConstraint(
            ["organization_id"],
            ["uam_organization.pk"],
            name=op.f("fk_procurement_quotation_organization_id_uam_organization"),
            ondelete="CASCADE",
        ),
        sa.ForeignKeyConstraint(
            ["vendor_id"],
            ["procurement_vendor.pk"],
            name=op.f("fk_procurement_quotation_vendor_id_procurement_vendor"),
            ondelete="RESTRICT",
        ),
        sa.PrimaryKeyConstraint("pk", name=op.f("pk_procurement_quotation")),
    )
    op.create_index(
        op.f("ix_procurement_quotation_delivery_term"),
        "procurement_quotation",
        ["delivery_term"],
        unique=False,
    )
    op.create_index(
        op.f("ix_procurement_quotation_payment_term"),
        "procurement_quotation",
        ["payment_term"],
        unique=False,
    )
    op.create_index(
        op.f("ix_procurement_quotation_status"),
        "procurement_quotation",
        ["status"],
        unique=False,
    )
    op.create_table(
        "procurement_requisition",
        sa.Column("requisition_id", sa.String(length=11), nullable=False),
        sa.Column("vendor_id", sa.BigInteger(), nullable=False),
        sa.Column(
            "status",
            postgresql.ENUM(
                "DRAFT",
                "APPROVED",
                "ISSUED",
                "CANCELLED",
                "COMPLETED",
                name="transactionstatus",
                create_type=False,
            ),
            nullable=False,
        ),
        sa.Column(
            "payment_term",
            postgresql.ENUM(
                "COD",
                "NET_N",
                "EOM",
                "EOM_N",
                "ADV",
                "DP",
                "STAG",
                name="transactionpaymentterm",
                create_type=False,
            ),
            nullable=False,
        ),
        sa.Column("payment_n", sa.Integer(), nullable=True),
        sa.Column("payment_dp_rate", sa.Numeric(precision=5, scale=4), nullable=True),
        sa.Column("payment_dp", sa.Numeric(precision=20, scale=4), nullable=True),
        sa.Column(
            "delivery_term",
            postgresql.ENUM(
                "EXW",
                "FCA",
                "CPT",
                "CIP",
                "DAP",
                "DPU",
                "DDP",
                "FAS",
                "FOB",
                "CFR",
                name="transactiondeliveryterm",
                create_type=False,
            ),
            nullable=True,
        ),
        sa.Column("discount_rate", sa.Numeric(precision=5, scale=4), nullable=True),
        sa.Column("discount_amount", sa.Numeric(precision=20, scale=4), nullable=True),
        sa.Column("total", sa.Numeric(precision=20, scale=4), nullable=False),
        sa.Column("total_discount", sa.Numeric(precision=20, scale=4), nullable=False),
        sa.Column(
            "total_global_discount", sa.Numeric(precision=20, scale=4), nullable=True
        ),
        sa.Column("total_before_vat", sa.Numeric(precision=20, scale=4), nullable=True),
        sa.Column("total_vat", sa.Numeric(precision=20, scale=4), nullable=False),
        sa.Column("total_net", sa.Numeric(precision=20, scale=4), nullable=False),
        sa.Column(
            "total_net_after_dp", sa.Numeric(precision=20, scale=4), nullable=True
        ),
        sa.Column("notes", sa.String(length=255), nullable=True),
        sa.Column("currency_id", sa.BigInteger(), nullable=False),
        sa.Column("approved_by_id", sa.BigInteger(), nullable=True),
        sa.Column("organization_id", sa.BigInteger(), nullable=False),
        sa.Column("deleted_at", sa.DateTime(timezone=True), nullable=True),
        sa.Column(
            "created_at",
            sa.DateTime(timezone=True),
            server_default=sa.text("now()"),
            nullable=False,
        ),
        sa.Column(
            "last_modified_at",
            sa.DateTime(timezone=True),
            server_default=sa.text("now()"),
            nullable=False,
        ),
        sa.Column("created_by_id", sa.BigInteger(), nullable=True),
        sa.Column("last_modified_by_id", sa.BigInteger(), nullable=True),
        sa.Column(
            "pk", sa.BigInteger(), sa.Identity(always=False, cycle=True), nullable=False
        ),
        sa.ForeignKeyConstraint(
            ["approved_by_id"],
            ["uam_user.pk"],
            name=op.f("fk_procurement_requisition_approved_by_id_uam_user"),
            ondelete="SET NULL",
        ),
        sa.ForeignKeyConstraint(
            ["created_by_id"],
            ["uam_user.pk"],
            name=op.f("fk_procurement_requisition_created_by_id_uam_user"),
            ondelete="SET NULL",
        ),
        sa.ForeignKeyConstraint(
            ["currency_id"],
            ["core_services_currency.pk"],
            name=op.f("fk_procurement_requisition_currency_id_core_services_currency"),
            ondelete="RESTRICT",
        ),
        sa.ForeignKeyConstraint(
            ["last_modified_by_id"],
            ["uam_user.pk"],
            name=op.f("fk_procurement_requisition_last_modified_by_id_uam_user"),
            ondelete="SET NULL",
        ),
        sa.ForeignKeyConstraint(
            ["organization_id"],
            ["uam_organization.pk"],
            name=op.f("fk_procurement_requisition_organization_id_uam_organization"),
            ondelete="CASCADE",
        ),
        sa.ForeignKeyConstraint(
            ["vendor_id"],
            ["procurement_vendor.pk"],
            name=op.f("fk_procurement_requisition_vendor_id_procurement_vendor"),
            ondelete="RESTRICT",
        ),
        sa.PrimaryKeyConstraint("pk", name=op.f("pk_procurement_requisition")),
    )
    op.create_index(
        op.f("ix_procurement_requisition_delivery_term"),
        "procurement_requisition",
        ["delivery_term"],
        unique=False,
    )
    op.create_index(
        op.f("ix_procurement_requisition_payment_term"),
        "procurement_requisition",
        ["payment_term"],
        unique=False,
    )
    op.create_index(
        op.f("ix_procurement_requisition_status"),
        "procurement_requisition",
        ["status"],
        unique=False,
    )
    op.create_table(
        "procurement_order",
        sa.Column("order_id", sa.String(length=11), nullable=False),
        sa.Column("quotation_id", sa.BigInteger(), nullable=True),
        sa.Column("vendor_id", sa.BigInteger(), nullable=False),
        sa.Column("total_paid", sa.Numeric(precision=20, scale=4), nullable=False),
        sa.Column(
            "status",
            postgresql.ENUM(
                "DRAFT",
                "APPROVED",
                "ISSUED",
                "CANCELLED",
                "COMPLETED",
                name="transactionstatus",
                create_type=False,
            ),
            nullable=False,
        ),
        sa.Column(
            "payment_term",
            postgresql.ENUM(
                "COD",
                "NET_N",
                "EOM",
                "EOM_N",
                "ADV",
                "DP",
                "STAG",
                name="transactionpaymentterm",
                create_type=False,
            ),
            nullable=False,
        ),
        sa.Column("payment_n", sa.Integer(), nullable=True),
        sa.Column("payment_dp_rate", sa.Numeric(precision=5, scale=4), nullable=True),
        sa.Column("payment_dp", sa.Numeric(precision=20, scale=4), nullable=True),
        sa.Column(
            "delivery_term",
            postgresql.ENUM(
                "EXW",
                "FCA",
                "CPT",
                "CIP",
                "DAP",
                "DPU",
                "DDP",
                "FAS",
                "FOB",
                "CFR",
                name="transactiondeliveryterm",
                create_type=False,
            ),
            nullable=True,
        ),
        sa.Column("discount_rate", sa.Numeric(precision=5, scale=4), nullable=True),
        sa.Column("discount_amount", sa.Numeric(precision=20, scale=4), nullable=True),
        sa.Column("total", sa.Numeric(precision=20, scale=4), nullable=False),
        sa.Column("total_discount", sa.Numeric(precision=20, scale=4), nullable=False),
        sa.Column(
            "total_global_discount", sa.Numeric(precision=20, scale=4), nullable=True
        ),
        sa.Column("total_before_vat", sa.Numeric(precision=20, scale=4), nullable=True),
        sa.Column("total_vat", sa.Numeric(precision=20, scale=4), nullable=False),
        sa.Column("total_net", sa.Numeric(precision=20, scale=4), nullable=False),
        sa.Column(
            "total_net_after_dp", sa.Numeric(precision=20, scale=4), nullable=True
        ),
        sa.Column("notes", sa.String(length=255), nullable=True),
        sa.Column("currency_id", sa.BigInteger(), nullable=False),
        sa.Column("approved_by_id", sa.BigInteger(), nullable=True),
        sa.Column("organization_id", sa.BigInteger(), nullable=False),
        sa.Column("deleted_at", sa.DateTime(timezone=True), nullable=True),
        sa.Column(
            "created_at",
            sa.DateTime(timezone=True),
            server_default=sa.text("now()"),
            nullable=False,
        ),
        sa.Column(
            "last_modified_at",
            sa.DateTime(timezone=True),
            server_default=sa.text("now()"),
            nullable=False,
        ),
        sa.Column("created_by_id", sa.BigInteger(), nullable=True),
        sa.Column("last_modified_by_id", sa.BigInteger(), nullable=True),
        sa.Column(
            "pk", sa.BigInteger(), sa.Identity(always=False, cycle=True), nullable=False
        ),
        sa.ForeignKeyConstraint(
            ["approved_by_id"],
            ["uam_user.pk"],
            name=op.f("fk_procurement_order_approved_by_id_uam_user"),
            ondelete="SET NULL",
        ),
        sa.ForeignKeyConstraint(
            ["created_by_id"],
            ["uam_user.pk"],
            name=op.f("fk_procurement_order_created_by_id_uam_user"),
            ondelete="SET NULL",
        ),
        sa.ForeignKeyConstraint(
            ["currency_id"],
            ["core_services_currency.pk"],
            name=op.f("fk_procurement_order_currency_id_core_services_currency"),
            ondelete="RESTRICT",
        ),
        sa.ForeignKeyConstraint(
            ["last_modified_by_id"],
            ["uam_user.pk"],
            name=op.f("fk_procurement_order_last_modified_by_id_uam_user"),
            ondelete="SET NULL",
        ),
        sa.ForeignKeyConstraint(
            ["organization_id"],
            ["uam_organization.pk"],
            name=op.f("fk_procurement_order_organization_id_uam_organization"),
            ondelete="CASCADE",
        ),
        sa.ForeignKeyConstraint(
            ["quotation_id"],
            ["procurement_quotation.pk"],
            name=op.f("fk_procurement_order_quotation_id_procurement_quotation"),
            ondelete="RESTRICT",
        ),
        sa.ForeignKeyConstraint(
            ["vendor_id"],
            ["procurement_vendor.pk"],
            name=op.f("fk_procurement_order_vendor_id_procurement_vendor"),
            ondelete="RESTRICT",
        ),
        sa.PrimaryKeyConstraint("pk", name=op.f("pk_procurement_order")),
        sa.UniqueConstraint(
            "quotation_id", name=op.f("uq_procurement_order_quotation_id")
        ),
    )
    op.create_index(
        op.f("ix_procurement_order_delivery_term"),
        "procurement_order",
        ["delivery_term"],
        unique=False,
    )
    op.create_index(
        op.f("ix_procurement_order_payment_term"),
        "procurement_order",
        ["payment_term"],
        unique=False,
    )
    op.create_index(
        op.f("ix_procurement_order_status"),
        "procurement_order",
        ["status"],
        unique=False,
    )
    op.create_table(
        "procurement_invoice",
        sa.Column(
            "status",
            postgresql.ENUM(
                "DRAFT",
                "APPROVED",
                "ISSUED",
                "CANCELLED",
                "PARTIALLY_PAID",
                "OVER_PAID",
                "PAID",
                name="invoicestatus",
                create_type=False,
            ),
            nullable=False,
        ),
        sa.Column("invoice_id", sa.String(length=11), nullable=False),
        sa.Column("order_id", sa.BigInteger(), nullable=False),
        sa.Column(
            "payment_term",
            postgresql.ENUM(
                "COD",
                "NET_N",
                "EOM",
                "EOM_N",
                "ADV",
                "DP",
                "STAG",
                name="transactionpaymentterm",
                create_type=False,
            ),
            nullable=True,
        ),
        sa.Column("payment_n", sa.Integer(), nullable=True),
        sa.Column("payment_dp_rate", sa.Numeric(precision=5, scale=4), nullable=True),
        sa.Column("payment_dp", sa.Numeric(precision=20, scale=4), nullable=True),
        sa.Column(
            "delivery_term",
            postgresql.ENUM(
                "EXW",
                "FCA",
                "CPT",
                "CIP",
                "DAP",
                "DPU",
                "DDP",
                "FAS",
                "FOB",
                "CFR",
                name="transactiondeliveryterm",
                create_type=False,
            ),
            nullable=True,
        ),
        sa.Column("discount_rate", sa.Numeric(precision=5, scale=4), nullable=True),
        sa.Column("discount_amount", sa.Numeric(precision=20, scale=4), nullable=True),
        sa.Column("total", sa.Numeric(precision=20, scale=4), nullable=False),
        sa.Column("total_discount", sa.Numeric(precision=20, scale=4), nullable=False),
        sa.Column(
            "total_global_discount", sa.Numeric(precision=20, scale=4), nullable=True
        ),
        sa.Column("total_before_vat", sa.Numeric(precision=20, scale=4), nullable=True),
        sa.Column("total_vat", sa.Numeric(precision=20, scale=4), nullable=False),
        sa.Column("total_net", sa.Numeric(precision=20, scale=4), nullable=False),
        sa.Column(
            "total_net_after_dp", sa.Numeric(precision=20, scale=4), nullable=True
        ),
        sa.Column("total_paid", sa.Numeric(precision=20, scale=4), nullable=False),
        sa.Column("notes", sa.String(length=255), nullable=True),
        sa.Column("approved_by_id", sa.BigInteger(), nullable=True),
        sa.Column("organization_id", sa.BigInteger(), nullable=False),
        sa.Column("deleted_at", sa.DateTime(timezone=True), nullable=True),
        sa.Column(
            "created_at",
            sa.DateTime(timezone=True),
            server_default=sa.text("now()"),
            nullable=False,
        ),
        sa.Column(
            "last_modified_at",
            sa.DateTime(timezone=True),
            server_default=sa.text("now()"),
            nullable=False,
        ),
        sa.Column("created_by_id", sa.BigInteger(), nullable=True),
        sa.Column("last_modified_by_id", sa.BigInteger(), nullable=True),
        sa.Column(
            "pk", sa.BigInteger(), sa.Identity(always=False, cycle=True), nullable=False
        ),
        sa.ForeignKeyConstraint(
            ["approved_by_id"],
            ["uam_user.pk"],
            name=op.f("fk_procurement_invoice_approved_by_id_uam_user"),
            ondelete="SET NULL",
        ),
        sa.ForeignKeyConstraint(
            ["created_by_id"],
            ["uam_user.pk"],
            name=op.f("fk_procurement_invoice_created_by_id_uam_user"),
            ondelete="SET NULL",
        ),
        sa.ForeignKeyConstraint(
            ["last_modified_by_id"],
            ["uam_user.pk"],
            name=op.f("fk_procurement_invoice_last_modified_by_id_uam_user"),
            ondelete="SET NULL",
        ),
        sa.ForeignKeyConstraint(
            ["order_id"],
            ["procurement_order.pk"],
            name=op.f("fk_procurement_invoice_order_id_procurement_order"),
            ondelete="RESTRICT",
        ),
        sa.ForeignKeyConstraint(
            ["organization_id"],
            ["uam_organization.pk"],
            name=op.f("fk_procurement_invoice_organization_id_uam_organization"),
            ondelete="CASCADE",
        ),
        sa.PrimaryKeyConstraint("pk", name=op.f("pk_procurement_invoice")),
    )
    op.create_index(
        op.f("ix_procurement_invoice_delivery_term"),
        "procurement_invoice",
        ["delivery_term"],
        unique=False,
    )
    op.create_index(
        op.f("ix_procurement_invoice_payment_term"),
        "procurement_invoice",
        ["payment_term"],
        unique=False,
    )
    op.create_index(
        op.f("ix_procurement_invoice_status"),
        "procurement_invoice",
        ["status"],
        unique=False,
    )
    op.create_table(
        "procurement_order_item",
        sa.Column("order_id", sa.BigInteger(), nullable=False),
        sa.Column("total_paid", sa.Numeric(precision=20, scale=4), nullable=False),
        sa.Column("quantity", sa.Numeric(precision=20, scale=4), nullable=False),
        sa.Column("price", sa.Numeric(precision=20, scale=4), nullable=False),
        sa.Column("discount_rate", sa.Numeric(precision=5, scale=4), nullable=True),
        sa.Column("discount_amount", sa.Numeric(precision=20, scale=4), nullable=True),
        sa.Column("vat_rate", sa.Numeric(precision=5, scale=4), nullable=False),
        sa.Column("total", sa.Numeric(precision=20, scale=4), nullable=False),
        sa.Column("total_discount", sa.Numeric(precision=20, scale=4), nullable=False),
        sa.Column(
            "total_global_discount", sa.Numeric(precision=20, scale=4), nullable=True
        ),
        sa.Column("total_before_vat", sa.Numeric(precision=20, scale=4), nullable=True),
        sa.Column("total_vat", sa.Numeric(precision=20, scale=4), nullable=False),
        sa.Column("total_net", sa.Numeric(precision=20, scale=4), nullable=False),
        sa.Column("vat_id", sa.BigInteger(), nullable=True),
        sa.Column("product_id", sa.BigInteger(), nullable=False),
        sa.Column(
            "pk", sa.BigInteger(), sa.Identity(always=False, cycle=True), nullable=False
        ),
        sa.ForeignKeyConstraint(
            ["order_id"],
            ["procurement_order.pk"],
            name=op.f("fk_procurement_order_item_order_id_procurement_order"),
            ondelete="CASCADE",
        ),
        sa.ForeignKeyConstraint(
            ["product_id"],
            ["inventory_product.pk"],
            name=op.f("fk_procurement_order_item_product_id_inventory_product"),
            ondelete="RESTRICT",
        ),
        sa.ForeignKeyConstraint(
            ["vat_id"],
            ["core_services_vat.pk"],
            name=op.f("fk_procurement_order_item_vat_id_core_services_vat"),
            ondelete="RESTRICT",
        ),
        sa.PrimaryKeyConstraint("pk", name=op.f("pk_procurement_order_item")),
        sa.UniqueConstraint(
            "order_id",
            "product_id",
            name="uq_procurement_order_item_order_id_product_id",
        ),
    )
    op.create_table(
        "procurement_quotation_item",
        sa.Column("quotation_id", sa.BigInteger(), nullable=False),
        sa.Column("quantity", sa.Numeric(precision=20, scale=4), nullable=False),
        sa.Column("price", sa.Numeric(precision=20, scale=4), nullable=False),
        sa.Column("discount_rate", sa.Numeric(precision=5, scale=4), nullable=True),
        sa.Column("discount_amount", sa.Numeric(precision=20, scale=4), nullable=True),
        sa.Column("vat_rate", sa.Numeric(precision=5, scale=4), nullable=False),
        sa.Column("total", sa.Numeric(precision=20, scale=4), nullable=False),
        sa.Column("total_discount", sa.Numeric(precision=20, scale=4), nullable=False),
        sa.Column(
            "total_global_discount", sa.Numeric(precision=20, scale=4), nullable=True
        ),
        sa.Column("total_before_vat", sa.Numeric(precision=20, scale=4), nullable=True),
        sa.Column("total_vat", sa.Numeric(precision=20, scale=4), nullable=False),
        sa.Column("total_net", sa.Numeric(precision=20, scale=4), nullable=False),
        sa.Column("vat_id", sa.BigInteger(), nullable=True),
        sa.Column("product_id", sa.BigInteger(), nullable=False),
        sa.Column(
            "pk", sa.BigInteger(), sa.Identity(always=False, cycle=True), nullable=False
        ),
        sa.ForeignKeyConstraint(
            ["product_id"],
            ["inventory_product.pk"],
            name=op.f("fk_procurement_quotation_item_product_id_inventory_product"),
            ondelete="RESTRICT",
        ),
        sa.ForeignKeyConstraint(
            ["quotation_id"],
            ["procurement_quotation.pk"],
            name=op.f(
                "fk_procurement_quotation_item_quotation_id_procurement_quotation"
            ),
            ondelete="CASCADE",
        ),
        sa.ForeignKeyConstraint(
            ["vat_id"],
            ["core_services_vat.pk"],
            name=op.f("fk_procurement_quotation_item_vat_id_core_services_vat"),
            ondelete="RESTRICT",
        ),
        sa.PrimaryKeyConstraint("pk", name=op.f("pk_procurement_quotation_item")),
        sa.UniqueConstraint(
            "quotation_id",
            "product_id",
            name="uq_procurement_quotation_item_quotation_id_product_id",
        ),
    )
    op.create_table(
        "procurement_requisition_item",
        sa.Column("requisition_id", sa.BigInteger(), nullable=False),
        sa.Column("quantity", sa.Numeric(precision=20, scale=4), nullable=False),
        sa.Column("price", sa.Numeric(precision=20, scale=4), nullable=False),
        sa.Column("discount_rate", sa.Numeric(precision=5, scale=4), nullable=True),
        sa.Column("discount_amount", sa.Numeric(precision=20, scale=4), nullable=True),
        sa.Column("vat_rate", sa.Numeric(precision=5, scale=4), nullable=False),
        sa.Column("total", sa.Numeric(precision=20, scale=4), nullable=False),
        sa.Column("total_discount", sa.Numeric(precision=20, scale=4), nullable=False),
        sa.Column(
            "total_global_discount", sa.Numeric(precision=20, scale=4), nullable=True
        ),
        sa.Column("total_before_vat", sa.Numeric(precision=20, scale=4), nullable=True),
        sa.Column("total_vat", sa.Numeric(precision=20, scale=4), nullable=False),
        sa.Column("total_net", sa.Numeric(precision=20, scale=4), nullable=False),
        sa.Column("vat_id", sa.BigInteger(), nullable=True),
        sa.Column("product_id", sa.BigInteger(), nullable=False),
        sa.Column(
            "pk", sa.BigInteger(), sa.Identity(always=False, cycle=True), nullable=False
        ),
        sa.ForeignKeyConstraint(
            ["product_id"],
            ["inventory_product.pk"],
            name=op.f("fk_procurement_requisition_item_product_id_inventory_product"),
            ondelete="RESTRICT",
        ),
        sa.ForeignKeyConstraint(
            ["requisition_id"],
            ["procurement_requisition.pk"],
            name=op.f(
                "fk_procurement_requisition_item_requisition_id_procurement_requisition"
            ),
            ondelete="CASCADE",
        ),
        sa.ForeignKeyConstraint(
            ["vat_id"],
            ["core_services_vat.pk"],
            name=op.f("fk_procurement_requisition_item_vat_id_core_services_vat"),
            ondelete="RESTRICT",
        ),
        sa.PrimaryKeyConstraint("pk", name=op.f("pk_procurement_requisition_item")),
        sa.UniqueConstraint(
            "requisition_id",
            "product_id",
            name="uq_procurement_requisition_item_requisition_id_product_id",
        ),
    )
    op.create_table(
        "procurement_invoice_item",
        sa.Column("invoice_id", sa.BigInteger(), nullable=False),
        sa.Column("order_item_id", sa.BigInteger(), nullable=False),
        sa.Column("quantity", sa.Numeric(precision=20, scale=4), nullable=False),
        sa.Column("price", sa.Numeric(precision=20, scale=4), nullable=False),
        sa.Column("discount_rate", sa.Numeric(precision=5, scale=4), nullable=True),
        sa.Column("discount_amount", sa.Numeric(precision=20, scale=4), nullable=True),
        sa.Column("vat_rate", sa.Numeric(precision=5, scale=4), nullable=False),
        sa.Column("total", sa.Numeric(precision=20, scale=4), nullable=False),
        sa.Column("total_discount", sa.Numeric(precision=20, scale=4), nullable=False),
        sa.Column(
            "total_global_discount", sa.Numeric(precision=20, scale=4), nullable=True
        ),
        sa.Column("total_before_vat", sa.Numeric(precision=20, scale=4), nullable=True),
        sa.Column("total_vat", sa.Numeric(precision=20, scale=4), nullable=False),
        sa.Column("total_net", sa.Numeric(precision=20, scale=4), nullable=False),
        sa.Column("total_paid", sa.Numeric(precision=20, scale=4), nullable=False),
        sa.Column(
            "pk", sa.BigInteger(), sa.Identity(always=False, cycle=True), nullable=False
        ),
        sa.ForeignKeyConstraint(
            ["invoice_id"],
            ["procurement_invoice.pk"],
            name=op.f("fk_procurement_invoice_item_invoice_id_procurement_invoice"),
            ondelete="CASCADE",
        ),
        sa.ForeignKeyConstraint(
            ["order_item_id"],
            ["procurement_order_item.pk"],
            name=op.f(
                "fk_procurement_invoice_item_order_item_id_procurement_order_item"
            ),
            ondelete="RESTRICT",
        ),
        sa.PrimaryKeyConstraint("pk", name=op.f("pk_procurement_invoice_item")),
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("procurement_invoice_item")
    op.drop_table("procurement_requisition_item")
    op.drop_table("procurement_quotation_item")
    op.drop_table("procurement_order_item")
    op.drop_index(
        op.f("ix_procurement_invoice_status"), table_name="procurement_invoice"
    )
    op.drop_index(
        op.f("ix_procurement_invoice_payment_term"), table_name="procurement_invoice"
    )
    op.drop_index(
        op.f("ix_procurement_invoice_delivery_term"), table_name="procurement_invoice"
    )
    op.drop_table("procurement_invoice")
    op.drop_index(op.f("ix_procurement_order_status"), table_name="procurement_order")
    op.drop_index(
        op.f("ix_procurement_order_payment_term"), table_name="procurement_order"
    )
    op.drop_index(
        op.f("ix_procurement_order_delivery_term"), table_name="procurement_order"
    )
    op.drop_table("procurement_order")
    op.drop_index(
        op.f("ix_procurement_requisition_status"), table_name="procurement_requisition"
    )
    op.drop_index(
        op.f("ix_procurement_requisition_payment_term"),
        table_name="procurement_requisition",
    )
    op.drop_index(
        op.f("ix_procurement_requisition_delivery_term"),
        table_name="procurement_requisition",
    )
    op.drop_table("procurement_requisition")
    op.drop_index(
        op.f("ix_procurement_quotation_status"), table_name="procurement_quotation"
    )
    op.drop_index(
        op.f("ix_procurement_quotation_payment_term"),
        table_name="procurement_quotation",
    )
    op.drop_index(
        op.f("ix_procurement_quotation_delivery_term"),
        table_name="procurement_quotation",
    )
    op.drop_table("procurement_quotation")
    op.drop_table("procurement_vendor")
    op.drop_table("procurement_requisition_counter")
    op.drop_table("procurement_quotation_counter")
    op.drop_table("procurement_order_counter")
    op.drop_table("procurement_invoice_counter")
    # ### end Alembic commands ###
