from fastapi import Depends

from be_kit.databases import DBConfig
from .settings import settings


db_config = DBConfig(settings)


def get_db_config():
    yield db_config


async def get_async_session(config: DBConfig = Depends(get_db_config)):
    async with config.async_sessionmaker() as session:
        try:
            yield session
        finally:
            await session.close()
