# symbolix-erp-procurement

Procurement Services

## Conda Setup

```bash
conda create -n symbolix-erp-procurement python=3.12.3
```

## Install/Upgrade Development Kit

You can use `dev` option to retrieve from repositories:

```bash
pip install -e .[dev] --config-settings editable_mode=strict
```

or install all dependencies manually from local folders:

```bash
pip install -e ../symbolix-be-py_kit[all] --config-settings editable_mode=strict
pip install -e ../symbolix-erp-uam --config-settings editable_mode=strict
pip install -e ../symbolix-erp-core_services --config-settings editable_mode=strict
pip install -e ../symbolix-erp-accounting --config-settings editable_mode=strict
pip install -e ../symbolix-erp-inventory --config-settings editable_mode=strict
pip install -e ../symbolix-erp-crm --config-settings editable_mode=strict
pip install -e . --config-settings editable_mode=strict
```

## Running Development Server

```bash
be-procurement
```

## Git Management

### Precommit

To ensure code quality and consistency, run the pre-commit hooks before pushing your changes. This will automatically check and format your code according to the project's standards:

```bash
be-precommit
```

If any issues are found, fix them and re-run the command until all checks pass.

### Commit Message

Follow the [Conventional Commits](https://www.conventionalcommits.org/en/v1.0.0/) specification for your commit messages. This standard helps automate versioning and changelog generation.

A conventional commit message consists of a type, an optional scope, and a concise description:

```
<type>[optional scope]: <description>
```

**Types include:**

-   `feat`: A new feature
-   `fix`: A bug fix
-   `docs`: Documentation changes
-   `style`: Code style changes (formatting, missing semi colons, etc.)
-   `refactor`: Code changes that neither fix a bug nor add a feature
-   `perf`: Performance improvements
-   `test`: Adding or updating tests
-   `chore`: Changes to the build process or auxiliary tools

**Examples:**

```
feat(auth): add JWT authentication
fix(database): resolve connection leak
docs(readme): update setup instructions
```

Refer to the [Conventional Commits documentation](https://www.conventionalcommits.org/en/v1.0.0/) for more details and examples.


### Tagging a Release

Release and dev package creation is managed by CI/CD:

-   **Development Package:**
    Pushing to the `develop` branch triggers CI to build and publish a dev package.
    Manually bump the version using `bump2version [major|minor|patch|build]` before pushing.

-   **Release Package:**
    Creating or pushing a tag in GitLab will trigger CI to build and publish a release package. Normally, tags are created manually using:

    ```bash
    bump2version --tag release
    git push && git push --tags
    ```

    Make sure to push both commits and tags to ensure the release process is triggered.

## Migrations

```bash
alembic revision --autogenerate -m "procurement: [migration message]"
```

```bash
alembic upgrade head
```

```bash
alembic downgrade -1
```

## Unit Test

```bash
coverage run -m pytest --disable-warnings --junitxml=xunit-report.xml
coverage report
coverage xml
```

```bash
docker run \
    --rm \
    --network=symbolix \
    -v "$PWD:/usr/src" \
    -e SONAR_HOST_URL="http://sonarqube:9000" \
    sonarsource/sonar-scanner-cli
```

## Build and Run in Binary Mode

```bash
pyinstaller \
    --distpath bin/dist \
    --workpath bin/build \
    --clean api.spec
```

```bash
./bin/dist/api
```

These variables configure the package registry URL and authentication credentials required for publishing.

Next, build and push the package to the registry using:

```bash
be-publish
```

## Build Docker Image

To build a Docker image for the application, use:

```bash
export $(grep BE_CI_AUTH_TOKEN .env | xargs)

docker build \
    --rm --no-cache \
    --build-arg AUTH_TOKEN="$BE_CI_AUTH_TOKEN" \
    -f .docker/Dockerfile \
    -t symbolix-procurement:latest .
```

```bash
docker build \
    --rm --no-cache \
    --build-arg SSH_PRIVATE_KEY="$(cat ~/.ssh/id_rsa)" \
    -f Dockerfile \
    -t symbolix-procurement:latest .
```

## Run Standalone Docker Image

```bash
docker run --name symbolix-procurement \
    -p 55508:8000 \
    --network=symbolix \
    --env-file local.env \
    --restart=always \
    --detach \
    symbolix-procurement:latest
```
