"""expense: initial migrations

Revision ID: 836c78cccbac
Revises: 
Create Date: 2025-11-18 14:18:23.815349

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
import be_kit.databases


# revision identifiers, used by Alembic.
revision: str = '836c78cccbac'
down_revision: Union[str, None] = None
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('expense_counter',
    sa.Column('counter_date', sa.Date(), nullable=False),
    sa.Column('counter', sa.BigInteger(), nullable=False),
    sa.Column('organization_id', sa.BigInteger(), nullable=False),
    sa.Column('pk', sa.BigInteger(), nullable=False),
    sa.ForeignKeyConstraint(['organization_id'], ['uam_organization.pk'], name=op.f('fk_expense_counter_organization_id_uam_organization'), ondelete='RESTRICT'),
    sa.PrimaryKeyConstraint('pk', name=op.f('pk_expense_counter')),
    sa.UniqueConstraint('organization_id', 'counter_date', name=op.f('uq_expense_counter_organization_id'))
    )
    op.create_index(op.f('ix_expense_counter_counter_date'), 'expense_counter', ['counter_date'], unique=False)
    op.create_table('expense_category',
    sa.Column('name', sa.String(length=100), nullable=False),
    sa.Column('description', sa.String(length=500), nullable=True),
    sa.Column('account_id', sa.BigInteger(), nullable=False),
    sa.Column('deleted_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('organization_id', sa.BigInteger(), nullable=False),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('last_modified_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('created_by_id', sa.BigInteger(), nullable=True),
    sa.Column('last_modified_by_id', sa.BigInteger(), nullable=True),
    sa.Column('pk', sa.BigInteger(), nullable=False),
    sa.ForeignKeyConstraint(['account_id'], ['accounting_coa_account.pk'], name=op.f('fk_expense_category_account_id_accounting_coa_account'), ondelete='RESTRICT'),
    sa.ForeignKeyConstraint(['created_by_id'], ['uam_user.pk'], name=op.f('fk_expense_category_created_by_id_uam_user'), ondelete='SET NULL'),
    sa.ForeignKeyConstraint(['last_modified_by_id'], ['uam_user.pk'], name=op.f('fk_expense_category_last_modified_by_id_uam_user'), ondelete='SET NULL'),
    sa.ForeignKeyConstraint(['organization_id'], ['uam_organization.pk'], name=op.f('fk_expense_category_organization_id_uam_organization'), ondelete='RESTRICT'),
    sa.PrimaryKeyConstraint('pk', name=op.f('pk_expense_category')),
    sa.UniqueConstraint('organization_id', 'name', name=op.f('uq_expense_category_organization_id'))
    )
    op.create_index(op.f('ix_expense_category_name'), 'expense_category', ['name'], unique=False)
    op.create_table('expense',
    sa.Column('description', sa.String(length=500), nullable=True),
    sa.Column('identifier', sa.String(length=10), nullable=False),
    sa.Column('expense_date', sa.Date(), nullable=False),
    sa.Column('notes', sa.String(length=2000), nullable=True),
    sa.Column('status', sa.Enum('DRAFT', 'SUBMITTED', 'APPROVED', 'CANCELLED', 'COMPLETED', name='expensestatus'), nullable=False),
    sa.Column('category_id', sa.BigInteger(), nullable=False),
    sa.Column('currency_id', sa.BigInteger(), nullable=False),
    sa.Column('employee_id', sa.BigInteger(), nullable=False),
    sa.Column('amount', be_kit.databases.NominalField(precision=30, scale=15), nullable=False),
    sa.Column('deleted_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('approved_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('approved_by_id', sa.BigInteger(), nullable=True),
    sa.Column('rejected_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('cancelled_by_id', sa.BigInteger(), nullable=True),
    sa.Column('organization_id', sa.BigInteger(), nullable=False),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('last_modified_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('created_by_id', sa.BigInteger(), nullable=True),
    sa.Column('last_modified_by_id', sa.BigInteger(), nullable=True),
    sa.Column('pk', sa.BigInteger(), nullable=False),
    sa.ForeignKeyConstraint(['approved_by_id'], ['uam_user.pk'], name=op.f('fk_expense_approved_by_id_uam_user'), ondelete='SET NULL'),
    sa.ForeignKeyConstraint(['cancelled_by_id'], ['uam_user.pk'], name=op.f('fk_expense_cancelled_by_id_uam_user'), ondelete='SET NULL'),
    sa.ForeignKeyConstraint(['category_id'], ['expense_category.pk'], name=op.f('fk_expense_category_id_expense_category'), ondelete='RESTRICT'),
    sa.ForeignKeyConstraint(['created_by_id'], ['uam_user.pk'], name=op.f('fk_expense_created_by_id_uam_user'), ondelete='SET NULL'),
    sa.ForeignKeyConstraint(['currency_id'], ['core_services_currency.pk'], name=op.f('fk_expense_currency_id_core_services_currency'), ondelete='RESTRICT'),
    sa.ForeignKeyConstraint(['employee_id'], ['uam_user.pk'], name=op.f('fk_expense_employee_id_uam_user'), ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['last_modified_by_id'], ['uam_user.pk'], name=op.f('fk_expense_last_modified_by_id_uam_user'), ondelete='SET NULL'),
    sa.ForeignKeyConstraint(['organization_id'], ['uam_organization.pk'], name=op.f('fk_expense_organization_id_uam_organization'), ondelete='RESTRICT'),
    sa.PrimaryKeyConstraint('pk', name=op.f('pk_expense')),
    sa.UniqueConstraint('organization_id', 'identifier', name=op.f('uq_expense_organization_id'))
    )
    op.create_index(op.f('ix_expense_expense_date'), 'expense', ['expense_date'], unique=False)
    op.create_index(op.f('ix_expense_identifier'), 'expense', ['identifier'], unique=True)
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f('ix_expense_identifier'), table_name='expense')
    op.drop_index(op.f('ix_expense_expense_date'), table_name='expense')
    op.drop_table('expense')
    op.drop_index(op.f('ix_expense_category_name'), table_name='expense_category')
    op.drop_table('expense_category')
    op.drop_index(op.f('ix_expense_counter_counter_date'), table_name='expense_counter')
    op.drop_table('expense_counter')
    # ### end Alembic commands ###
