from be_uam.permission.utils import generate_permission_list


permissions = generate_permission_list(
    app="expense",
    module="expense",
    submodule="expense_category",
    action=[
        "create",
        "read",
        "update",
        "delete",
    ],
)


expense_category_permission_mapper = {
    "create_expense_category": ["expense.expense.expense_category.create"],
    "retrieve_expense_category": ["expense.expense.expense_category.read"],
    "update_expense_category": ["expense.expense.expense_category.update"],
    "list_expense_category": ["expense.expense.expense_category.read"],
    "list_expense_category_option": ["expense.expense.expense_category.read"],
    "delete_expense_category": ["expense.expense.expense_category.delete"],
}


permissions += generate_permission_list(
    app="expense",
    module="expense",
    submodule="expense",
    action=[
        "create",
        "read",
        "update",
        "delete",
        "approve",
        "cancel",
    ],
)


expense_permission_mapper = {
    "create_expense": ["expense.expense.expense.create"],
    "retrieve_expense": ["expense.expense.expense.read"],
    "update_expense": ["expense.expense.expense.update"],
    "list_expense": ["expense.expense.expense.read"],
    "list_expense_option": ["expense.expense.expense.read"],
    "delete_expense": ["expense.expense.expense.delete"],
    "download_upload_expense_template": ["expense.expense.expense.create"],
    "upload_expense": ["expense.expense.expense.create"],
    "download_expense": ["expense.expense.expense.read"],
    "approve_expense": ["expense.expense.expense.approve"],
    "cancel_expense": ["expense.expense.expense.cancel"],
}
