from enum import Enum

from be_kit.enums import StrEnumWithMixins
from be_uam.kit.enums import MetadataOrderingMixin


class ExpenseStatus(Enum):
    DRAFT = "Draft"
    SUBMITTED = "Submitted"
    APPROVED = "Approved"
    CANCELLED = "Cancelled"
    COMPLETED = "Completed"


class ExpenseCategoryOrdering(MetadataOrderingMixin, StrEnumWithMixins):
    NAME = "name"
    NAME_DESC = "-name"
    DESCRIPTION = "description"
    DESCRIPTION_DESC = "-description"


class ExpenseOrdering(MetadataOrderingMixin, StrEnumWithMixins):
    DESCRIPTION = "description"
    DESCRIPTION_DESC = "-description"
    IDENTIFIER = "identifier"
    IDENTIFIER_DESC = "-identifier"
    DATE = "date"
    DATE_DESC = "-date"
    STATUS = "status"
    STATUS_DESC = "-status"
    AMOUNT = "amount"
    AMOUNT_DESC = "-amount"


