import argparse

from .settings import settings
from .tasks import task_handler


task_handler.client.autodiscover_tasks(
    [
        "be_uam.user.utils.send_verification_email",
        "be_uam.auth.utils.send_otp_email",
    ]
)


run_worker_parser = argparse.ArgumentParser(
    description="Run task worker for specified queues."
)
run_worker_parser.add_argument(
    "--queue_names",
    type=str,
    default=",".join(settings.task.queue_names),
    help="Comma-separated names of the queues to process",
)


def run_worker():
    args = run_worker_parser.parse_args()
    queue_names = [q.strip() for q in args.queue_names.split(",") if q.strip()]
    task_handler.run_worker(queue_names)
