from sqlalchemy import Select, select

from be_kit.repositories import BaseRepository

from . import models


class BaseUserMixin:
    model = models.User

    def get_by_email(self, email: str):
        obj = self.session.execute(select(self.model).where(self.model.email == email))
        obj = obj.scalar()
        return obj

    async def aget_by_email(self, email: str):
        obj = await self.session.execute(
            select(self.model).where(self.model.email == email)
        )
        obj = obj.scalar()
        return obj

    def get_by_username(self, username: str):
        obj = self.session.execute(
            select(self.model).where(self.model.username == username)
        )
        obj = obj.scalar()
        return obj

    async def aget_by_username(self, username: str):
        obj = await self.session.execute(
            select(self.model).where(self.model.username == username)
        )
        obj = obj.scalar()
        return obj


class UserRepository(BaseUserMixin, BaseRepository):
    filter_by_organization = True

    def add_organization_filter(self, query: Select):
        query = query.filter(self.model.group.has(organization_id=self.organization_id))
        return query


class InitialUserRepository(BaseUserMixin, BaseRepository):
    pass


class AuthUserRepository(BaseUserMixin, BaseRepository):
    pass
