from enum import Enum

from be_kit.enums import StrEnumWithMixins


class VerificationContext(Enum):
    REGISTRATION = "Registration"
    NEW_USER = "New User"
    CHANGE_PASSWORD = "Change Password"
    RESET_PASSWORD = "Reset Password"


class MetadataOrderingMixin:
    CREATED_AT = "created_at"
    CREATED_AT_DESC = "-created_at"
    LAST_MODIFIED_AT = "last_modified_at"
    LAST_MODIFIED_AT_DESC = "-last_modified_at"


class UserOrdering(MetadataOrderingMixin, StrEnumWithMixins):
    USERNAME = "username"
    USERNAME_DESC = "-username"
    EMAIL = "email"
    EMAIL_DESC = "-email"
