from pydantic import BaseModel

from be_kit.settings import (
    CoreSettings,
    MailingSettings,
    TaskSettings,
    RedisSettings,
)


class JWTSettings(BaseModel):
    access_token_expire: int = 1
    refresh_token_expire: int = 7
    access_cookie_name: str = "X-ACCESS-TOKEN"
    refresh_cookie_name: str = "X-REFRESH-TOKEN"


class Settings(CoreSettings):
    service_name: str = "User Access Management"
    service_shortname: str = "uam"
    version: str = "0.16.1.dev1"
    auth_fail_attempts: int = 5
    auth_fail_ttl: int = 60 * 30
    jwt: JWTSettings = JWTSettings()
    mailing: MailingSettings = MailingSettings()
    redis: RedisSettings = RedisSettings()
    task: TaskSettings = TaskSettings()


settings = Settings()
