from sqlalchemy.orm import Session
from sqlalchemy.ext.asyncio import AsyncSession

from ..organization.repositories import GroupTaskRepository
from . import models, schemas, repositories


async def list_permissions(
    db: AsyncSession,
    filters: schemas.PermissionFilter,
):
    repo = repositories.PermissionRepository(db)
    objs = await repo.arecords(filters)
    return objs


def generate_permission_list(app: str, module: str, submodule: str, action: list[str]):
    permissions = []
    for act in action:
        permissions.append(
            {
                "app": app,
                "module": module,
                "submodule": submodule,
                "action": act,
                "code": f"{app}.{module}.{submodule}.{act}",
            }
        )
    return permissions


def populate_permissions(db: Session, permissions: list[dict]):
    repo = repositories.PermissionRepository(db)
    objs = repo.populate_initial(permissions)

    group_repo = GroupTaskRepository(db)
    group_perm_repo = repositories.GroupPermissionRepository(db)
    for root_group in group_repo.records({"parent_id": None}):
        group_perms = [
            models.GroupPermission(group_id=root_group.pk, permission_id=perm.pk)
            for perm in objs
        ]
        group_perm_repo.bulk_create(group_perms, _commit=False)

    db.commit()
