from fastapi import APIRouter, Depends
from sqlalchemy.ext.asyncio import AsyncSession

from ..databases import get_async_session
from ..auth.utils import get_request_user
from . import schemas, utils


router = APIRouter(tags=["permission"], prefix="/permission")


@router.get(
    "/",
    response_model=list[schemas.Permission],
    dependencies=[Depends(get_request_user)],
)
async def list_permission(
    filters: schemas.PermissionFilter = Depends(),
    session: AsyncSession = Depends(get_async_session),
):
    return await utils.list_permissions(session, filters)
