from ..permission.utils import generate_permission_list


permissions = generate_permission_list(
    app="uam",
    module="organization",
    submodule="organization",
    action=["read", "update"],
)


organization_permission_mapper = {
    "retrieve_organization": ["uam.organization.organization.read"],
    "list_organization": ["uam.organization.organization.read"],
    "list_organization_option": ["uam.organization.organization.read"],
    "update_organization": ["uam.organization.organization.update"],
}


permissions += generate_permission_list(
    app="uam",
    module="organization",
    submodule="group",
    action=[
        "create",
        "read",
        "update",
        "delete",
    ],
)


group_permission_mapper = {
    "create_group": ["uam.organization.group.create"],
    "retrieve_group": ["uam.organization.group.read"],
    "list_group": ["uam.organization.group.read"],
    "list_group_option": ["uam.organization.group.read"],
    "update_group": ["uam.organization.group.update"],
    "delete_group": ["uam.organization.group.delete"],
    "get_group_permissions": ["uam.organization.group.read"],
    "set_group_permissions": ["uam.organization.group.update"],
}
