from enum import Enum

from be_kit.enums import StrEnumWithMixins
from ..user.enums import MetadataOrderingMixin


class OrganizationLegalType(Enum):
    INDIVIDUAL = "Individual"
    PARTNERSHIP = "Partnership"
    LIMITED_PARTNERSHIP = "Limited Partnership"
    LIMITED_LIABILITY_PARTNERSHIP = "Limited Liability Partnership"
    LIMITED_LIABILITY_COMPANY = "Limited Liability Company"
    PUBLIC_LIMITED_COMPANY = "Public Limited Company"
    PRIVATE_LIMITED_COMPANY = "Private Limited Company"
    CORPORATION = "Corporation"
    NONPROFIT_ORGANIZATION = "Nonprofit Organization"
    COOPERATIVE = "Cooperative"
    TRUST = "Trust"
    GOVERNMENT_AGENCY = "Government Agency"


class OrganizationOrdering(MetadataOrderingMixin, StrEnumWithMixins):
    LEGAL_NAME = "legal_name"
    LEGAL_NAME_DESC = "-legal_name"
    LEGAL_TYPE = "legal_type"
    LEGAL_TYPE_DESC = "-legal_type"


class GroupOrdering(MetadataOrderingMixin, StrEnumWithMixins):
    NAME = "name"
    NAME_DESC = "-name"
