"""uam: add audit log

Revision ID: 12be85a8c824
Revises: 383a3a6bde4a
Create Date: 2025-09-19 01:57:04.657570

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = '12be85a8c824'
down_revision: Union[str, None] = '383a3a6bde4a'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('uam_audit_log',
    sa.Column('pk', sa.BigInteger(), nullable=False),
    sa.Column('app', sa.String(length=100), nullable=False),
    sa.Column('module', sa.String(length=100), nullable=False),
    sa.Column('submodule', sa.String(length=100), nullable=False),
    sa.Column('action', sa.Enum('CREATE', 'UPDATE', 'DELETE', 'LOGIN', 'LOGOUT', 'PASSWORD_CHANGE', 'PASSWORD_RESET', 'FAILED_LOGIN', 'LOCKOUT', 'UNLOCK', 'PERMISSION_CHANGE', 'ROLE_CHANGE', 'DATA_EXPORT', 'DATA_IMPORT', name='auditlogaction'), nullable=False),
    sa.Column('description', sa.String(length=255), nullable=False),
    sa.Column('before', sa.JSON(), nullable=True),
    sa.Column('after', sa.JSON(), nullable=True),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('created_by_id', sa.BigInteger(), nullable=True),
    sa.Column('organization_id', sa.BigInteger(), nullable=False),
    sa.ForeignKeyConstraint(['created_by_id'], ['uam_user.pk'], name=op.f('fk_uam_audit_log_created_by_id_uam_user'), ondelete='SET NULL'),
    sa.ForeignKeyConstraint(['organization_id'], ['uam_organization.pk'], name=op.f('fk_uam_audit_log_organization_id_uam_organization'), ondelete='RESTRICT'),
    sa.PrimaryKeyConstraint('pk', name=op.f('pk_uam_audit_log'))
    )
    op.create_index(op.f('ix_uam_audit_log_action'), 'uam_audit_log', ['action'], unique=False)
    op.create_index(op.f('ix_uam_audit_log_app'), 'uam_audit_log', ['app'], unique=False)
    op.create_index(op.f('ix_uam_audit_log_module'), 'uam_audit_log', ['module'], unique=False)
    op.create_index(op.f('ix_uam_audit_log_submodule'), 'uam_audit_log', ['submodule'], unique=False)
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f('ix_uam_audit_log_submodule'), table_name='uam_audit_log')
    op.drop_index(op.f('ix_uam_audit_log_module'), table_name='uam_audit_log')
    op.drop_index(op.f('ix_uam_audit_log_app'), table_name='uam_audit_log')
    op.drop_index(op.f('ix_uam_audit_log_action'), table_name='uam_audit_log')
    op.drop_table('uam_audit_log')
    # ### end Alembic commands ###
