"""uam: populate initial permissions

Revision ID: 383a3a6bde4a
Revises: 7456343e47a5
Create Date: 2025-08-01 16:05:45.543164

"""

from typing import Sequence, Union

from alembic import op
from sqlalchemy.orm import Session
from be_uam.permission.utils import populate_permissions
from be_uam.permissions import permissions


# revision identifiers, used by Alembic.
revision: str = "383a3a6bde4a"
down_revision: Union[str, None] = "7456343e47a5"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    db = Session(bind=op.get_bind())
    populate_permissions(db, permissions)
    db.close()


def downgrade() -> None:
    pass
