"""uam: add organization relations

Revision ID: 7456343e47a5
Revises: 5afec7a4e674
Create Date: 2025-07-31 17:38:24.042639

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = '7456343e47a5'
down_revision: Union[str, None] = '5afec7a4e674'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('uam_user', sa.Column('group_id', sa.BigInteger(), nullable=True))
    op.create_foreign_key(op.f('fk_uam_user_group_id_uam_organization_group'), 'uam_user', 'uam_organization_group', ['group_id'], ['pk'], ondelete='RESTRICT')
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(op.f('fk_uam_user_group_id_uam_organization_group'), 'uam_user', type_='foreignkey')
    op.drop_column('uam_user', 'group_id')
    # ### end Alembic commands ###
