"""uam: initial migrations

Revision ID: 5afec7a4e674
Revises: 
Create Date: 2025-07-31 17:37:53.902824

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = '5afec7a4e674'
down_revision: Union[str, None] = None
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('uam_permission',
    sa.Column('app', sa.String(length=30), nullable=False),
    sa.Column('module', sa.String(length=30), nullable=False),
    sa.Column('submodule', sa.String(length=30), nullable=False),
    sa.Column('action', sa.String(length=50), nullable=False),
    sa.Column('pk', sa.BigInteger(), nullable=False),
    sa.PrimaryKeyConstraint('pk', name=op.f('pk_uam_permission')),
    sa.UniqueConstraint('app', 'module', 'submodule', 'action', name=op.f('uq_uam_permission_app'))
    )
    op.create_table('uam_user',
    sa.Column('pk', sa.BigInteger(), nullable=False),
    sa.Column('username', sa.String(length=50), nullable=False),
    sa.Column('email', sa.String(length=100), nullable=False),
    sa.Column('password', sa.String(length=128), nullable=True),
    sa.Column('first_name', sa.String(length=50), nullable=False),
    sa.Column('last_name', sa.String(length=50), nullable=False),
    sa.Column('is_superuser', sa.Boolean(), nullable=False),
    sa.Column('is_active', sa.Boolean(), nullable=False),
    sa.Column('is_verified', sa.Boolean(), server_default=sa.text('false'), nullable=False),
    sa.Column('is_locked', sa.Boolean(), server_default=sa.text('false'), nullable=False),
    sa.Column('last_login_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('need_change_password', sa.Boolean(), server_default=sa.text('true'), nullable=False),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('last_modified_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('created_by_id', sa.BigInteger(), nullable=True),
    sa.Column('last_modified_by_id', sa.BigInteger(), nullable=True),
    sa.ForeignKeyConstraint(['created_by_id'], ['uam_user.pk'], name=op.f('fk_uam_user_created_by_id_uam_user'), ondelete='SET NULL'),
    sa.ForeignKeyConstraint(['last_modified_by_id'], ['uam_user.pk'], name=op.f('fk_uam_user_last_modified_by_id_uam_user'), ondelete='SET NULL'),
    sa.PrimaryKeyConstraint('pk', name=op.f('pk_uam_user'))
    )
    op.create_index(op.f('ix_uam_user_email'), 'uam_user', ['email'], unique=True)
    op.create_index(op.f('ix_uam_user_username'), 'uam_user', ['username'], unique=True)
    op.create_table('uam_organization',
    sa.Column('pk', sa.BigInteger(), nullable=False),
    sa.Column('legal_type', sa.Enum('INDIVIDUAL', 'PARTNERSHIP', 'LIMITED_PARTNERSHIP', 'LIMITED_LIABILITY_PARTNERSHIP', 'LIMITED_LIABILITY_COMPANY', 'PUBLIC_LIMITED_COMPANY', 'PRIVATE_LIMITED_COMPANY', 'CORPORATION', 'NONPROFIT_ORGANIZATION', 'COOPERATIVE', 'TRUST', 'GOVERNMENT_AGENCY', name='organizationlegaltype'), nullable=False),
    sa.Column('legal_name', sa.String(length=150), nullable=False),
    sa.Column('maintainer_id', sa.BigInteger(), nullable=False),
    sa.Column('parent_id', sa.BigInteger(), nullable=True),
    sa.Column('deleted_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('last_modified_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('created_by_id', sa.BigInteger(), nullable=True),
    sa.Column('last_modified_by_id', sa.BigInteger(), nullable=True),
    sa.ForeignKeyConstraint(['created_by_id'], ['uam_user.pk'], name=op.f('fk_uam_organization_created_by_id_uam_user'), ondelete='SET NULL'),
    sa.ForeignKeyConstraint(['last_modified_by_id'], ['uam_user.pk'], name=op.f('fk_uam_organization_last_modified_by_id_uam_user'), ondelete='SET NULL'),
    sa.ForeignKeyConstraint(['maintainer_id'], ['uam_user.pk'], name=op.f('fk_uam_organization_maintainer_id_uam_user'), ondelete='RESTRICT'),
    sa.ForeignKeyConstraint(['parent_id'], ['uam_organization.pk'], name=op.f('fk_uam_organization_parent_id_uam_organization'), ondelete='RESTRICT'),
    sa.PrimaryKeyConstraint('pk', name=op.f('pk_uam_organization'))
    )
    op.create_index(op.f('ix_uam_organization_legal_name'), 'uam_organization', ['legal_name'], unique=True)
    op.create_index(op.f('ix_uam_organization_legal_type'), 'uam_organization', ['legal_type'], unique=False)
    op.create_table('uam_organization_group',
    sa.Column('pk', sa.BigInteger(), nullable=False),
    sa.Column('organization_id', sa.BigInteger(), nullable=False),
    sa.Column('name', sa.String(length=150), nullable=False),
    sa.Column('parent_id', sa.BigInteger(), nullable=True),
    sa.Column('deleted_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('last_modified_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('created_by_id', sa.BigInteger(), nullable=True),
    sa.Column('last_modified_by_id', sa.BigInteger(), nullable=True),
    sa.ForeignKeyConstraint(['created_by_id'], ['uam_user.pk'], name=op.f('fk_uam_organization_group_created_by_id_uam_user'), ondelete='SET NULL'),
    sa.ForeignKeyConstraint(['last_modified_by_id'], ['uam_user.pk'], name=op.f('fk_uam_organization_group_last_modified_by_id_uam_user'), ondelete='SET NULL'),
    sa.ForeignKeyConstraint(['organization_id'], ['uam_organization.pk'], name=op.f('fk_uam_organization_group_organization_id_uam_organization'), ondelete='RESTRICT'),
    sa.ForeignKeyConstraint(['parent_id'], ['uam_organization_group.pk'], name=op.f('fk_uam_organization_group_parent_id_uam_organization_group'), ondelete='RESTRICT'),
    sa.PrimaryKeyConstraint('pk', name=op.f('pk_uam_organization_group')),
    sa.UniqueConstraint('organization_id', 'name', name=op.f('uq_uam_organization_group_organization_id'))
    )
    op.create_table('uam_organization_group_permission',
    sa.Column('group_id', sa.BigInteger(), nullable=True),
    sa.Column('permission_id', sa.BigInteger(), nullable=True),
    sa.Column('pk', sa.BigInteger(), nullable=False),
    sa.ForeignKeyConstraint(['group_id'], ['uam_organization_group.pk'], name=op.f('fk_uam_organization_group_permission_group_id_uam_organization_group'), ondelete='RESTRICT'),
    sa.ForeignKeyConstraint(['permission_id'], ['uam_permission.pk'], name=op.f('fk_uam_organization_group_permission_permission_id_uam_permission'), ondelete='RESTRICT'),
    sa.PrimaryKeyConstraint('pk', name=op.f('pk_uam_organization_group_permission')),
    sa.UniqueConstraint('group_id', 'permission_id', name=op.f('uq_uam_organization_group_permission_group_id'))
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('uam_organization_group_permission')
    op.drop_table('uam_organization_group')
    op.drop_index(op.f('ix_uam_organization_legal_type'), table_name='uam_organization')
    op.drop_index(op.f('ix_uam_organization_legal_name'), table_name='uam_organization')
    op.drop_table('uam_organization')
    op.drop_index(op.f('ix_uam_user_username'), table_name='uam_user')
    op.drop_index(op.f('ix_uam_user_email'), table_name='uam_user')
    op.drop_table('uam_user')
    op.drop_table('uam_permission')
    # ### end Alembic commands ###
