from datetime import datetime
from typing_extensions import Annotated

from pydantic import EmailStr, PositiveInt, StringConstraints

from be_kit.paginations import BasePaginatedResponse
from be_kit.schemas import BaseSchema, BaseORMSchema
from ..user.schemas import UserMin
from ..kit.schemas import MetadataMixin, OrganizationMixin
from .enums import AuditLogAction


class AuditLog(OrganizationMixin, BaseORMSchema):
    app: Annotated[str, StringConstraints(min_length=1, max_length=100)]
    module: Annotated[str, StringConstraints(min_length=1, max_length=100)]
    submodule: Annotated[str, StringConstraints(min_length=1, max_length=100)]
    action: AuditLogAction
    description: Annotated[str | None, StringConstraints(max_length=255)]
    before: dict | None
    after: dict | None
    created_at: datetime
    created_by: "UserMin | None"


class AuditLogDetail(AuditLog):
    before: dict | None
    after: dict | None


class PaginatedAuditLog(BasePaginatedResponse):
    items: list[AuditLog]


class AuditLogFilter(BaseSchema):
    created_at__gte: datetime | None = None
    created_at__lte: datetime | None = None
    created_by_id: PositiveInt | None = None
    created_by__username: str | None = None
    created_by__email: EmailStr | None = None
    app: str | None = None
    module: str | None = None
    submodule: str | None = None
    action: AuditLogAction | None = None
