from datetime import datetime

from sqlalchemy import (
    BigInteger,
    Boolean,
    DateTime,
    Enum,
    ForeignKey,
    JSON,
    String,
    func,
    sql,
)
from sqlalchemy.ext.declarative import declared_attr
from sqlalchemy.orm import Mapped, mapped_column, relationship

from be_kit import dateutils
from be_kit.databases import BaseModel
from ..user.models import User
from ..kit.models import OrganizationMixin

from .enums import AuditLogAction


class AuditLog(OrganizationMixin, BaseModel):
    __tablename__ = "uam_audit_log"

    pk: Mapped[int] = mapped_column(BigInteger, primary_key=True)
    app: Mapped[str] = mapped_column(String(100), index=True)
    module: Mapped[str] = mapped_column(String(100), index=True)
    submodule: Mapped[str] = mapped_column(String(100), index=True)
    action: Mapped[AuditLogAction] = mapped_column(Enum(AuditLogAction), index=True)
    description: Mapped[str] = mapped_column(String(255))
    before: Mapped[dict | None] = mapped_column(JSON, nullable=True)
    after: Mapped[dict | None] = mapped_column(JSON, nullable=True)
    created_at: Mapped[datetime] = mapped_column(
        DateTime(timezone=True), server_default=func.now()
    )
    created_by_id: Mapped[int | None] = mapped_column(
        BigInteger,
        ForeignKey("uam_user.pk", ondelete="SET NULL"),
        default=None,
        nullable=True,
    )
    created_by: Mapped[User] = relationship(
        User,
        foreign_keys=[created_by_id],
        passive_deletes=True,
        lazy="selectin",
    )
