from enum import Enum

from be_kit.enums import StrEnumWithMixins
from ..kit.enums import MetadataOrderingMixin


class AuditLogAction(Enum):
    CREATE = "Create"
    UPDATE = "Update"
    DELETE = "Delete"
    LOGIN = "Login"
    LOGOUT = "Logout"
    PASSWORD_CHANGE = "Password Change"
    PASSWORD_RESET = "Password Reset"
    FAILED_LOGIN = "Failed Login"
    LOCKOUT = "Lockout"
    UNLOCK = "Unlock"
    PERMISSION_CHANGE = "Permission Change"
    ROLE_CHANGE = "Role Change"
    DATA_EXPORT = "Data Export"
    DATA_IMPORT = "Data Import"


class AuditLogOrdering(MetadataOrderingMixin, StrEnumWithMixins):
    APP = "app"
    APP_DESC = "-app"
    MODULE = "module"
    MODULE_DESC = "-module"
    SUBMODULE = "submodule"
    SUBMODULE_DESC = "-submodule"
    ACTION = "action"
    ACTION_DESC = "-action"
